/*
 *  main SOAP-XMLHttpRequest code (IE only parts)
 */


  /************************
   * path to global files *
   ************************/
  var sh_pathToGlobals = __pathToGlobals;

  /******************
   * use namespaces *
   ******************/
  var sh_useNamespaces = false;
  function sh_switchUseNamespaces(checkbox) {
      sh_useNamespaces = checkbox.checked;
  }


  
  /***************
   * get browser *
   ***************/
  var sh_browser = __browser;

  /**************************************
   * prepare empty DOMDocument instance *
   **************************************/
  var sh_requestBody;
  function sh_clearRequestBody() {
    if (sh_browser == 'IE') {
      sh_requestBody = new ActiveXObject('Msxml2.DOMDocument');
    }
  }
  sh_clearRequestBody();

  /***********************************************
   * function for creating XSLT-transform object *
   ***********************************************/
  sh_readInXSLT = __readInXSLT;

  /********************
   * default SOAP URI *
   ********************/
  var sh_namespaceURI = 'http://schemas.xmlsoap.org/soap/envelope/';

  /******************
   * error handling *
   ******************/
  function sh_errorCase(error) {  
    if (error.where == 'SOAPFault') {
      alert('SOAPFault generated:\n\n'+error.detail.element+'\n'+error.detail.faultCode+'\n'+error.detail.faultString);
    } else {
      alert('Other error than SOAPFault:\n\n'+error.where+'\n'+error.detail);
    }
  }
  
  /*********************
   * 'connecting' logo *
   *********************/
  function sh_printStartOfConnecting(node) {
    node.innerHTML = 'Connecting, please wait...';
  }
  function sh_printEndOfConnecting(node) {
    node.innerHTML = '';
  }
  
  /************************************************************
   * debug: dump SOAPCall and SOAPResponse strings (to alert) *
   ************************************************************/
  if (!sh_debug)
    var sh_debug = false;
  if (sh_debug) {
    var sh_debug_soapmsg = '';
    if (sh_browser == 'IE') {
      // The path is relative to HTML-document from which this file is called!!!
      var sh_debug_xslDoc = sh_readInXSLT(sh_pathToGlobals+'/xml-html.xsl');
      var sh_debug_xslProc = sh_debug_xslDoc.createProcessor();
    }
    function sh_debugFnc(input, message) {
      if (sh_browser == 'IE') {
        if (typeof(input) == 'object') {
          sh_debug_xslProc.input = input;
          sh_debug_xslProc.transform();
	  sh_debug_soapmsg += "<fieldset><legend>" + message  + ":</legend><div>" + sh_debug_xslProc.output + "</div></fieldset>";
	} else {
	  sh_debug_soapmsg += "<fieldset><legend>" + message  + ":</legend><div>" + input + "</div></fieldset>";
	}
      }
    }
    function sh_showDebug() {
      var sh_debug_win = window.open("", "", "directories=no,location=no,menubar=no,status=no,toolbar=no,resizable=yes,scrollbars=yes");
      sh_debug_win.document.write('<html><head>');
      sh_debug_win.document.write('<title>SOAP conversation</title>');
      sh_debug_win.document.write('<style type="text/css">@import url("'+sh_pathToGlobals+'/style.css");</style>');
      sh_debug_win.document.write('</head><body>');
      sh_debug_win.document.write(sh_debug_soapmsg);
      sh_debug_win.document.write('</body></html>');
    }
  }


/* ******************************************************************************************************************************* */


  /************
   * SOAPCall *
   ************/
  function sh_SOAPCall() {
    this.destinationURI = null;
    this.targetObjectURI = null;
    this.actionURI = null;
    this.encodingStyleURI = null;
    this.methodName = null;
    this.status = null;
    this.envelope = null;
    this.header = null;
    this.body = null;
    this._soapBody = null;
    this.setParameters = function() {
      var namespaceIterator = 0;
      var nameSpace = 'ns'+namespaceIterator;
      if (arguments.length == 0) {
        var tmpEl = sh_requestBody.createElement(nameSpace+':'+this.methodName);
        tmpEl.setAttribute('xmlns:'+nameSpace, this.targetObjectURI);
        this._soapBody = tmpEl;
      } else {
        var tmpEl = sh_requestBody.createElement(nameSpace+':'+this.methodName);
        tmpEl.setAttribute('xmlns:'+nameSpace, this.targetObjectURI);
        var i=0;
        while (i<arguments.length) {
          var param = arguments[i];
          var tmpElInn = param._makeChild(namespaceIterator);
          tmpEl.appendChild(tmpElInn);
          i++;
        }
        this._soapBody = tmpEl;
      }
    }
    this.invoke = function() {
      throw "Method not implemented";
    }
    this.asyncInvoke = function(onresponse) {
      var thisObject = this;
      var so;
      function onResponseHandler() {
        // function for retrieving the first child element
        // body of the function
        var r = new sh_SOAPResponse();
        r._XMLHttpRequest.channel = so.channel;
        r._XMLHttpRequest.responseXML = so.responseXML;
        r._XMLHttpRequest.responseText = so.responseText;
        r._XMLHttpRequest.status = so.status;
        r._XMLHttpRequest.statusText = so.statusText;
	//
        if (so.status < 100 || so.status>999) {
          alert("Unknown status code " + so.status + " " + so.status.length);
	  eval(onresponse(null, null));
          return;
        }
        if (!(so.status>=200 && so.status<300) && !(so.status>=500 && so.status<600)) {
          alert("Unsupported status code " + so.status);
	  eval(onresponse(null, null));
          return;
        }
        //
        if (sh_debug) sh_debugFnc(so.responseXML, "Response");
        var responseXML = so.responseXML;
        r.envelope = __getFirstElementWithNameNS(responseXML, sh_namespaceURI, 'Envelope');
	if (r.envelope == null) {
	  if (sh_debug) {
  	    alert("Could not contact web service. See soap conversation for details.");
	    sh_debugFnc(so.responseText, "Failed message");
          } else {
  	    alert("Could not contact web service.");
	  }
	  eval(onresponse(null, null));
	  return;	  
	}
        r.header = __getFirstElementWithNameNS(responseXML, sh_namespaceURI, 'Header');
        r.body = __getFirstElementWithNameNS(responseXML, sh_namespaceURI, 'Body');
        //
        var firstOne = __getFirstChild(r.body);
        if (sh_browser == 'NN') {	// get namespace related 'material'
          r.targetObjectURI = firstOne.namespaceURI;
          r.methodName = firstOne.localName;
        }
        r.returnValue = (firstOne.hasChildNodes()) ? __getFirstChild(firstOne) : null;
        // next should be done by namespace-aware methods
        if ((r.returnValue != null) && (r.returnValue.getAttribute('xsi:null') == 'true')) {
          r.returnValue = null;
        }
        var isFault = false;
        if (sh_browser == 'IE') {	// no namespace method available
          isFault = firstOne.nodeName.indexOf(':Fault') != -1;
        }
        if (isFault) {
          var fault = new sh_SOAPFault();
          fault.element = firstOne;
          fault.faultCode = fault.element.getElementsByTagName('faultcode')[0].firstChild.nodeValue;
          fault.faultString = fault.element.getElementsByTagName('faultstring')[0].firstChild.nodeValue;
          r.fault = fault;
        }
        //
        eval(onresponse(r, thisObject));
      }
      //
      if (sh_browser == 'IE') {
        so = new ActiveXObject('Microsoft.XMLHTTP');
        //so = new ActiveXObject('Msxml2.XMLHTTP');
        so.onreadystatechange = function() { if (so.readyState == 4) onResponseHandler(); }
        //sh_requestBody = new ActiveXObject('Msxml2.DOMDocument');
        sh_clearRequestBody();
      }
      so.open('POST', this.destinationURI, true);
      if (this.actionURI == '') { so.setRequestHeader('SOAPAction', '""'); }
        else { so.setRequestHeader('SOAPAction', '"'+this.actionURI+'"'); }
      so.setRequestHeader('Content-Type', 'text/xml');
      // should be namespaced
      var elEnvelope = sh_requestBody.createElement('SOAP-ENV:Envelope');
      elEnvelope.setAttribute('xmlns:SOAP-ENV', sh_namespaceURI);
      elEnvelope.setAttribute('SOAP-ENV:encodingStyle', 'http://schemas.xmlsoap.org/soap/encoding/');
      elEnvelope.setAttribute('xmlns:SOAP-ENC', 'http://schemas.xmlsoap.org/soap/encoding/');
      elEnvelope.setAttribute('xmlns:xsi', 'http://www.w3.org/1999/XMLSchema-instance');
      elEnvelope.setAttribute('xmlns:xsd', 'http://www.w3.org/1999/XMLSchema');

      //disabled, because ms.net does not allow for empty headers
      //var elHeader = sh_requestBody.createElement('SOAP-ENV:Header');
      //elEnvelope.appendChild(elHeader);


      var elBody = sh_requestBody.createElement('SOAP-ENV:Body');
      if (this._soapBody == null) {	// just function call, no parameters
        this.setParameters();
      }
      elBody.appendChild(this._soapBody);
      elEnvelope.appendChild(elBody);
      sh_requestBody.appendChild(elEnvelope);
      if (sh_debug) {
        sh_debug_soapmsg = '';
        sh_debugFnc(sh_requestBody, "Request");
      }
      so.send(sh_requestBody);
    }
  }

  /*****************
   * SOAPParameter *
   *****************/
  function sh_SOAPParameter(name, type, namespaceURI, globalType, value) {
    this.name = name;
    this.type = type;
    this.namespaceURI = namespaceURI;
    this.value = value;
    //encodingStyleURI = null;
    //_parameters = ['unknown', 'null', 'void', 'string', 'boolean', 'double', 'float', 'long', 'int', 'short', 'byte', 'array', 'javascript_array', 'javascript_object'];
    this._makeChild = function(iterator) {
        var tmpEl;
        
        // create DOM element for SOAP call from this parameter
        switch (globalType) {
            case 'primitive':
                var namespace = 'ns'+iterator;
                if (sh_useNamespaces) {
                    tmpEl = sh_requestBody.createElement(namespace+":"+this.name);
                } else {
                    tmpEl = sh_requestBody.createElement(this.name);
                }
                tmpEl.setAttribute('xsi:type', 'xsd:'+this.type);
                var tmpTxt = sh_requestBody.createTextNode(this.value);
                tmpEl.appendChild(tmpTxt);
                break;
            case 'structure':
                ++iterator;
                var namespace = 'ns'+iterator;
                if (sh_useNamespaces) {
                    tmpEl = sh_requestBody.createElement(namespace+":"+this.name);
                } else {
                    tmpEl = sh_requestBody.createElement(this.name);
                }
                tmpEl.setAttribute('xmlns:'+namespace, this.namespaceURI);
                tmpEl.setAttribute('xsi:type', namespace+':'+this.type);
                for (var i in this.value) {
                    var tmpPar = this.value[i];
                    var tmpElInn = tmpPar._makeChild(iterator);
                    tmpEl.appendChild(tmpElInn);
                }
                break;
	   case 'array':
	        ++iterator;
                var namespace = 'ns'+iterator;
                if (sh_useNamespaces) {
                    tmpEl = sh_requestBody.createElement(namespace+":"+this.name);
                } else {
                    tmpEl = sh_requestBody.createElement(this.name);
                }
                tmpEl.setAttribute('xmlns:'+namespace, this.namespaceURI);	
                tmpEl.setAttribute('SOAP-ENC:arrayType', namespace+':'+this.type+'['+this.value.length+']');	
                for (var i in this.value) {
                    var tmpPar = this.value[i];
                    var tmpElInn = tmpPar._makeChild(iterator);
                    tmpEl.appendChild(tmpElInn);
                }
                break;	        
        }
        return tmpEl;
    }
  }

  /****************
   * SOAPResponse *
   ****************/
  function sh_SOAPResponse() {
    this.envelope = null;
    this.header = null;
    this.body = null;
    this.status = null;
    this.targetObjectURI = null;
    this.methodName = null;
    this.fault = null;
    this.returnValue = null;
    // for transfer of some important properties of XMLHttpRequest object
    this._XMLHttpRequest = {
      channel : null,
      responseText : null,
      responseXML : null,
      status : null,
      statusText : null
    }
    this.generatedFault = function() {
      var toReturn = null;
      var isFault = false;
      if (browser == 'IE') {	// no namespace method available
        isFault = firstOne.nodeName.indexOf(':Fault') != -1;
      }
      if (isFault) {
        toReturn = true;
      }
      return toReturn;
    }
  }

  /*************
   * SOAPFault *
   *************/
  function sh_SOAPFault() {
    this.element = null;
    this.faultCode = null;
    this.faultString = null;
    this.faultActor = null;
    this.detail = null;
  }


