<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0"> 

<xsl:key name="id" match="*" use="@id"/>

<xsl:template match="*">
  <xsl:param name="attrs"/>
  <xsl:copy>
    <xsl:copy-of select="@*"/>
    <xsl:copy-of select="$attrs"/>
    <xsl:apply-templates/>
  </xsl:copy>
</xsl:template>

<xsl:template match="*[@href]" priority="10">
  <xsl:apply-templates select="key('id',substring-after(@href,'#'))">
    <xsl:with-param name="attrs" select="@*[not(self::href)]"/>
  </xsl:apply-templates>
</xsl:template>

</xsl:stylesheet> 

