<xsl:stylesheet xmlns:xsl = "http://www.w3.org/1999/XSL/Transform" version = "1.0" xmlns:saxon="http://icl.com/saxon" extension-element-prefixes="saxon" > 


<xsl:template match="/">
  <xsl:call-template name="printXML">
    <xsl:with-param name="source" select="/*"/>
    <xsl:with-param name="elementClass" select="'xmlelement'"/>
    <xsl:with-param name="attributeClass" select="'xmlattribute'"/>
  </xsl:call-template>
</xsl:template>


<xsl:template name="printXML">
  <xsl:param name="source"/>
  <xsl:param name="makeElementLink"/>
  <xsl:param name="elementURLprefix"/>
  <xsl:param name="elementURLsuffix"/>
  <xsl:param name="target"/>
  <xsl:param name="elementClass"/>
  <xsl:param name="attributeClass"/>
  <xsl:param name="makeAttributeLink"/>
  <xsl:param name="attributeURLprefix"/>
  <xsl:param name="attributeURLsuffix"/>
  <xsl:param name="useElementNameInAttributeLink"/>
  <xsl:param name="connectorElementNameInAttributeLink"/>

  <xsl:apply-templates select="$source" mode="printXML_20011403">
    <xsl:with-param name="makeElementLink" select="$makeElementLink"/>
    <xsl:with-param name="elementURLprefix" select="$elementURLprefix"/>
    <xsl:with-param name="elementURLsuffix" select="$elementURLsuffix"/>
    <xsl:with-param name="target" select="$target"/>
    <xsl:with-param name="makeAttributeLink" select="$makeAttributeLink"/>
    <xsl:with-param name="attributeURLprefix" select="$attributeURLprefix"/>
    <xsl:with-param name="attributeURLsuffix" select="$attributeURLsuffix"/>
    <xsl:with-param name="useElementNameInAttributeLink" select="$useElementNameInAttributeLink"/>
    <xsl:with-param name="connectorElementNameInAttributeLink" select="$connectorElementNameInAttributeLink"/>
    <xsl:with-param name="elementClass" select="$elementClass"/>
    <xsl:with-param name="attributeClass" select="$attributeClass"/>
  </xsl:apply-templates>
</xsl:template>


<xsl:variable name="nbsp">&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;</xsl:variable>


<xsl:template name="indent_20011403">
  <xsl:param name="level"/>
  <xsl:value-of select="substring($nbsp,1,$level * 5)"/>
</xsl:template>


<xsl:template name="printName_20011403">
  <xsl:param name="name"/>
  <xsl:param name="makeLink"/>
  <xsl:param name="URLprefix"/>
  <xsl:param name="URLsuffix"/>
  <xsl:param name="target"/>
  <xsl:param name="class"/>

  <xsl:choose>
    <xsl:when test="$makeLink='yes'">
      <a href="{concat($URLprefix,local-name(),$URLsuffix)}">
	<xsl:if test="string-length($target) &gt; 0">
	  <xsl:attribute name="target">
	    <xsl:value-of select="$target"/>
	  </xsl:attribute>
	</xsl:if>
	<xsl:if test="string-length($class) &gt; 0">
	  <xsl:attribute name="class">
	    <xsl:value-of select="$class"/>
	  </xsl:attribute>
	</xsl:if>
	<xsl:value-of select="name()"/>
      </a>
    </xsl:when>
    <xsl:when test="string-length($class) &gt; 0">
      <span class="{$class}">
	<xsl:value-of select='$name'/>
      </span>
    </xsl:when>
    <xsl:otherwise>
      <xsl:value-of select='$name'/>
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>

<xsl:template match="*" mode="printXML_20011403">
  <xsl:param name="level" select="0"/>
  <xsl:param name="makeElementLink"/>
  <xsl:param name="elementURLprefix"/>
  <xsl:param name="elementURLsuffix"/>
  <xsl:param name="makeAttributeLink"/>
  <xsl:param name="attributeURLprefix"/>
  <xsl:param name="attributeURLsuffix"/>
  <xsl:param name="useElementNameInAttributeLink"/>
  <xsl:param name="connectorElementNameInAttributeLink"/>
  <xsl:param name="elementClass"/>
  <xsl:param name="attributeClass"/>
  <xsl:param name="target"/>
  
  <br/>
  <xsl:call-template name="indent_20011403">
    <xsl:with-param name="level" select="$level"/>
  </xsl:call-template>

  <xsl:text>&lt;</xsl:text>
  <xsl:call-template name="printName_20011403">
    <xsl:with-param name="name" select="name()"/>
    <xsl:with-param name="makeLink" select="$makeElementLink"/>
    <xsl:with-param name="URLprefix" select="$elementURLprefix"/>
    <xsl:with-param name="URLsuffix" select="$elementURLsuffix"/>
    <xsl:with-param name="target" select="$target"/>
    <xsl:with-param name="class" select="$elementClass"/>
  </xsl:call-template>

  <xsl:variable name="xxx">
    <xsl:if test="$useElementNameInAttributeLink = 'yes'">
      <xsl:value-of select="concat($attributeURLprefix,local-name(),$connectorElementNameInAttributeLink)"/>
    </xsl:if>
  </xsl:variable>

  <xsl:apply-templates select="@*" mode="printXML_20011403">
    <xsl:with-param name="makeAttributeLink" select="$makeAttributeLink"/>
    <xsl:with-param name="attributeURLprefix" select="$xxx"/>
    <xsl:with-param name="attributeURLsuffix" select="$attributeURLsuffix"/>
    <xsl:with-param name="target" select="$target"/>
    <xsl:with-param name="attributeClass" select="$attributeClass"/>
  </xsl:apply-templates>

  <xsl:call-template name="printNamespace_20011403"/>

  <xsl:if test="node()">
    <xsl:text>&gt;</xsl:text>
  </xsl:if>

  <xsl:apply-templates select="node()" mode="printXML_20011403">
    <xsl:with-param name="level" select="$level + 1"/>
    <xsl:with-param name="makeElementLink" select="$makeElementLink"/>
    <xsl:with-param name="elementURLprefix" select="$elementURLprefix"/>
    <xsl:with-param name="elementURLsuffix" select="$elementURLsuffix"/>
    <xsl:with-param name="target" select="$target"/>
    <xsl:with-param name="makeAttributeLink" select="$makeAttributeLink"/>
    <xsl:with-param name="attributeURLprefix" select="$attributeURLprefix"/>
    <xsl:with-param name="attributeURLsuffix" select="$attributeURLsuffix"/>
    <xsl:with-param name="useElementNameInAttributeLink" select="$useElementNameInAttributeLink"/>
    <xsl:with-param name="connectorElementNameInAttributeLink" select="$connectorElementNameInAttributeLink"/>
    <xsl:with-param name="elementClass" select="$elementClass"/>
    <xsl:with-param name="attributeClass" select="$attributeClass"/>
  </xsl:apply-templates>

  <xsl:choose>
    <xsl:when test="node()">
      <xsl:if test="* | text()[string-length(normalize-space(.)) != '' and contains(., '&#xA;')]">
	<br/>
	<xsl:call-template name="indent_20011403">
	  <xsl:with-param name="level" select="$level"/>
	</xsl:call-template>
      </xsl:if>
      <xsl:text>&lt;/</xsl:text>

      <xsl:call-template name="printName_20011403">
	<xsl:with-param name="name" select="name()"/>
	<xsl:with-param name="makeLink" select="$makeElementLink"/>
	<xsl:with-param name="URLprefix" select="$elementURLprefix"/>
	<xsl:with-param name="URLsuffix" select="$elementURLsuffix"/>
	<xsl:with-param name="target" select="$target"/>
	<xsl:with-param name="class" select="$elementClass"/>
      </xsl:call-template>

      <xsl:text>&gt;</xsl:text>
    </xsl:when>
    <xsl:otherwise>
      <xsl:text>/&gt;</xsl:text>
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>

<xsl:template match="@*" mode="printXML_20011403">
  <xsl:param name="target"/>
  <xsl:param name="makeAttributeLink"/>
  <xsl:param name="attributeURLprefix"/>
  <xsl:param name="attributeURLsuffix"/>
  <xsl:param name="attributeClass"/>

  <xsl:variable name="xxx">
    <xsl:choose>
      <xsl:when test='contains(.,"&apos;")'>'</xsl:when>
      <xsl:otherwise>"</xsl:otherwise>
    </xsl:choose>
  </xsl:variable>
  
  <xsl:text> </xsl:text>
  <xsl:call-template name="printName_20011403">
    <xsl:with-param name="name" select="name()"/>
    <xsl:with-param name="makeLink" select="$makeAttributeLink"/>
    <xsl:with-param name="URLprefix" select="$attributeURLprefix"/>
    <xsl:with-param name="URLsuffix" select="$attributeURLsuffix"/>
    <xsl:with-param name="target" select="$target"/>
    <xsl:with-param name="class" select="$attributeClass"/>
  </xsl:call-template>
  <span class="xmlattributevalue">
    <xsl:text>=</xsl:text>
    <xsl:value-of select="$xxx"/>
    <xsl:value-of select="."/>
    <xsl:value-of select="$xxx"/>
  </span>
</xsl:template>


<xsl:template name="printNamespace_20011403">
  <xsl:for-each select="namespace::*">
    <xsl:if test="not(starts-with(name(),'xml'))">
      <xsl:if test="not(ancestor::*[2][namespace::*[name()=name(current()) and .=current()]])">
	<span class="xmlnamespace">
	<xsl:text> xmlns</xsl:text>
	<xsl:if test="string-length(name())&gt;0">
	  <xsl:text>:</xsl:text>
	</xsl:if>
	<xsl:value-of select="name()"/>
	<xsl:text>="</xsl:text>
	<xsl:value-of select="."/>
	<xsl:text>" </xsl:text>
      </span>
      </xsl:if>
    </xsl:if>
  </xsl:for-each>
</xsl:template>


<xsl:template match="text()" mode="printXML_20011403">
  <xsl:param name="level"/>
  <xsl:choose>
    <xsl:when test="contains(., '&#xA;')">
      <br/>
      <xsl:call-template name="Line">
        <xsl:with-param name="data"><xsl:value-of select="."/></xsl:with-param>
        <xsl:with-param name="level" select="$level"/>
      </xsl:call-template>
    </xsl:when>
    <xsl:otherwise>
      <xsl:value-of select="."/>
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>


<xsl:template name="Line">
  <xsl:param name="data"/>
  <xsl:param name="level"/>
  <xsl:variable name="first">
    <xsl:choose>
      <xsl:when test="contains($data,'&#xA;')">
        <xsl:value-of select="substring-before($data,'&#xA;')"/>
      </xsl:when>
      <xsl:otherwise><xsl:value-of select="$data"/></xsl:otherwise>
    </xsl:choose>
  </xsl:variable>
  <xsl:variable name="rest">
    <xsl:value-of select="substring-after($data,'&#xA;')"/>
  </xsl:variable>

  <xsl:call-template name="indent_20011403">
    <xsl:with-param name="level" select="$level"/>
  </xsl:call-template>

  <xsl:value-of select="$first"/>
   
  <xsl:if test="not($rest='')">
    <br/>
    <xsl:call-template name="Line">
      <xsl:with-param name="data"><xsl:value-of select="$rest"/></xsl:with-param>
      <xsl:with-param name="level" select="$level"/>
    </xsl:call-template>
  </xsl:if>
</xsl:template>


</xsl:stylesheet> 







