package com.systinet.demos.interref;

import javax.wsdl.QName;

import org.idoox.wasp.Context;
import org.idoox.webservice.client.WebServiceLookup;

public final class OrderClient {

    public static void main( String[] args ) throws Exception {
        
      // lookup service
      WebServiceLookup lookup = (WebServiceLookup)Context.getInstance(Context.WEBSERVICE_LOOKUP);
      
      Order order = (Order)lookup.lookup("http://localhost:6060/OrderService/", 
                new QName("http://idoox.com/wasp/tools/java2wsdl/output/com/systinet/demos/interref/", "OrderService"),
                "OrderImpl", Order.class);
      
      String id1 = order.addItem("THNKPDT23", 2).getID();
      String id2 = order.addItem("THNKPDT22", 2).getID();
      
      System.out.println("ID1 "+id1);
      System.out.println("ID2 "+id2);
      
      LineItem item = order.getItem(id1);
      
      System.out.println("Line ITEM");
      System.out.println("---------");
      System.out.println("ID:         "+item.getID());
      System.out.println("Product ID: "+item.getProductID());
      System.out.println("Count:      "+item.getCount());
     
      item = order.getItem(id2);
      
      System.out.println("Line ITEM");
      System.out.println("---------");
      System.out.println("ID:         "+item.getID());
      System.out.println("Product ID: "+item.getProductID());
      System.out.println("Count:      "+item.getCount());

      
    }

}