package com.systinet.demos.counter;

import javax.naming.InitialContext;
import javax.naming.Context;
import javax.naming.NamingException;
import java.rmi.RemoteException;

public class CounterClient {

    public CounterClient() {
    }

   public static void main(String [] args){
        try {
            
      
           Context jndiContext = getInitialContext();
           
           Object homeRef = jndiContext.lookup("Counter");
           CounterHome home = (CounterHome)javax.rmi.PortableRemoteObject.narrow(homeRef, CounterHome.class);
           Counter ejb = home.create();
           System.out.println("Calling count "+ejb.getCount());
           System.out.println("Calling count "+ejb.getCount());
           System.out.println("Calling count "+ejb.getCount());
           ejb.remove();
        
        } 
        catch(java.rmi.RemoteException re) {
            re.printStackTrace();
        }
        catch(Throwable t) {
            t.printStackTrace();
        }
        
    }
  
    static public Context getInitialContext() throws javax.naming.NamingException {
        
        java.util.Properties jndiProperties = new java.util.Properties();
        
        jndiProperties.put("java.naming.factory.initial","com.idoox.jndi.InitialContextFactoryImpl");
        jndiProperties.put("java.naming.provider.url","http://localhost:6060");
        
        return new InitialContext(jndiProperties);
    }

}
