package com.systinet.demos.jms;

import org.idoox.wasp.Context;
import org.idoox.webservice.client.WebServiceLookup;


public final class StockClient {

  /**
   * @param args  not used.
   */
    public static void main( String[] args ) throws Exception {
      
      System.setProperty("java.naming.factory.initial","com.idoox.jndi.InitialContextFactoryImpl");  
      System.setProperty("java.naming.provider.url","http://localhost:6060");
      System.setProperty("idoox.demo.transport.j2ee", "true");
        
      // lookup service
      WebServiceLookup lookup = (WebServiceLookup)Context.getInstance(Context.WEBSERVICE_LOOKUP);
      // bind to StockQuoteService
      StockQuoteServiceProxy quoteService = (StockQuoteServiceProxy)lookup.lookup(
"jms://jms/Queue@jms/QueueConnectionFactory~/StockEJBService/",StockQuoteServiceProxy.class);
      

      // use StockQuoteService
         
      System.out.println("Getting SUNW quote");
      System.out.println("------------------------");
      System.out.println("SUNW "+quoteService.getQuote("SUNW"));
      System.out.println("");
      

    }

}