/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.demos.saml;

import org.idoox.webservice.CallContext;
import org.idoox.xml.Tokenizer;
import org.systinet.card.saml.SAMLUtils;
import org.systinet.card.saml.dsig.DOMTokenizer;
import org.systinet.card.saml.dsig.EnvelopedVerifier;
import org.systinet.card.saml.encoding.SAMLDeserializer;
import org.systinet.card.saml.encoding.header.CurrentProfile;
import org.systinet.card.saml.encoding.header.InputSAMLProfile;
import org.systinet.card.saml.structure.Assertion;
import org.systinet.card.saml.structure.AuthenticationStatement;
import org.systinet.card.saml.structure.NameIdentifier;
import org.systinet.card.saml.structure.Subject;
import org.w3c.dom.Element;

public class AuthenticatedService {
    public String getAuthInfo() {
        InputSAMLProfile inputSAMLProfile = CurrentProfile.getIn((CallContext)CallContext.getInstance());
        if (inputSAMLProfile.getAssertionCount() == 0) {
            return "No profile assertion received!";
        }
        StringBuffer stringBuffer = new StringBuffer(1000);
        stringBuffer.append("Assertions Received: " + inputSAMLProfile.getAssertionCount());
        stringBuffer.append('\n');
        int n = inputSAMLProfile.getAssertionCount();
        int n2 = 0;
        while (n2 < n) {
            Object object;
            Element element = inputSAMLProfile.getDOMAssertion(n2);
            try {
                stringBuffer.append("Assertion no " + n2 + " :");
                stringBuffer.append("\n\t");
                int n3 = EnvelopedVerifier.getCountOfSignatures((Element)element);
                stringBuffer.append("signatures: ").append(n3);
                stringBuffer.append("\n\t");
                if (n3 > 0) {
                    object = EnvelopedVerifier.getEnvelopedSignature((Element)element, (int)1);
                    stringBuffer.append("X509Certificate present: ");
                    stringBuffer.append(EnvelopedVerifier.containsX509Certificate((Element)object));
                    stringBuffer.append("\n\t");
                    stringBuffer.append("Signature verified: ");
                    stringBuffer.append(EnvelopedVerifier.verifyElement((Element)element, (Element)object));
                    stringBuffer.append("\n\t");
                }
            }
            catch (Exception exception) {
                stringBuffer.append("Exception received: " + exception.getMessage());
                exception.printStackTrace();
            }
            try {
                Assertion assertion = SAMLDeserializer.deserializeAssertion((Tokenizer)new DOMTokenizer(element));
                stringBuffer.append("Validy interval: ");
                object = assertion.getConditions();
                if (object != null) {
                    stringBuffer.append("<");
                    stringBuffer.append(object.getNotBefore().toString());
                    stringBuffer.append(",");
                    stringBuffer.append(object.getNotOnOrAfter().toString());
                    stringBuffer.append(")");
                } else {
                    stringBuffer.append("unspecified");
                }
                stringBuffer.append("\n\t");
                stringBuffer.append("Issued by: " + assertion.getIssuer());
                stringBuffer.append("\n\t");
                stringBuffer.append("Issue Instant Time: " + assertion.getIssueInstant());
                stringBuffer.append("\n\t");
                AuthenticationStatement[] authenticationStatementArray = assertion.getAuthenticationStatements();
                boolean bl = authenticationStatementArray != null && authenticationStatementArray.length > 0;
                stringBuffer.append("Contains authentication statement: " + bl);
                if (bl) {
                    stringBuffer.append("\n\t ");
                    stringBuffer.append("authentication method: " + authenticationStatementArray[0].getAuthenticationMethod());
                    stringBuffer.append("\n\t ");
                    stringBuffer.append("subject:");
                    Subject subject = authenticationStatementArray[0].getSubject();
                    if (subject != null && subject.getSubjectContents() != null && subject.getSubjectContents()[0].getNameIdentifier() != null) {
                        NameIdentifier nameIdentifier = subject.getSubjectContents()[0].getNameIdentifier();
                        stringBuffer.append("\n\t  ");
                        stringBuffer.append("name: " + nameIdentifier.getName());
                        stringBuffer.append("\n\t  ");
                        stringBuffer.append("security domain: " + nameIdentifier.getSecurityDomain());
                    }
                }
                stringBuffer.append("\n");
            }
            catch (Exception exception) {
                stringBuffer.append("Exception received: " + exception.getMessage());
                exception.printStackTrace();
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    public boolean verifySAMLProfile() {
        InputSAMLProfile inputSAMLProfile = CurrentProfile.getIn((CallContext)CallContext.getInstance());
        if (inputSAMLProfile.getAssertionCount() == 0) {
            return false;
        }
        int n = inputSAMLProfile.getAssertionCount();
        System.out.println("Count of received Assertions :" + n);
        int n2 = 0;
        if (n2 < n) {
            System.out.println("Verification of assertion no :" + n2);
            Element element = inputSAMLProfile.getDOMAssertion(n2);
            try {
                if (!EnvelopedVerifier.verifyElement((Element)element)) {
                    return false;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return false;
            }
            try {
                Assertion assertion = SAMLDeserializer.deserializeAssertion((Tokenizer)new DOMTokenizer(element));
                return SAMLUtils.isInValidityTime((Assertion)assertion);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return false;
            }
        }
        return false;
    }
}

