package com.systinet.demos.saml;

import java.util.Date;

import org.w3c.dom.Element;

import org.systinet.card.saml.SAMLUtils;
import org.systinet.card.saml.dsig.DOMTokenizer;
import org.systinet.card.saml.encoding.SAMLDeserializer;
import org.systinet.card.saml.dsig.EnvelopedVerifier;
import org.systinet.card.saml.encoding.header.CurrentProfile;
import org.systinet.card.saml.encoding.header.InputSAMLProfile;
import org.systinet.card.saml.structure.*;

import org.idoox.webservice.CallContext;
import org.idoox.wasp.serialization.xsdbuiltin.DateTime;

public class AuthenticatedService {
    
    /**
     * puts all received authentication info in the returned String
     */
    public String getAuthInfo() {
        /* 
        	retrieves the SAML assertion from the call context 
        	where it was placed by the server-side header processor
        	the header processor is in the WASP Card JARs
        */
        InputSAMLProfile profile = CurrentProfile.getIn(
            CallContext.getInstance()
        );
        
        if (profile.getAssertionCount()==0){
            return "No profile assertion received!";
        }
        else{
            /* 
        			puts all info from the assertion to the string an return 
        			it back to the calling client
        		*/
            StringBuffer buf = new StringBuffer(1000);
            buf.append("Assertions Received: "+profile.getAssertionCount());
            buf.append('\n');
            // process all assertions
            int count  = profile.getAssertionCount();
            for(int i=0; i<count; i++){
                Element elem = profile.getDOMAssertion(i);
                try{
                		// validates the digital signature
                    buf.append("Assertion no "+i+" :");
                    buf.append("\n\t");
                    int sigCount = EnvelopedVerifier.getCountOfSignatures(elem);
                    buf.append("signatures: ").append(sigCount);
                    buf.append("\n\t");
                    if (sigCount>0){
                        Element signature = 
                        EnvelopedVerifier.getEnvelopedSignature(
                            elem,1
                        );
                        buf.append("X509Certificate present: ");
                        buf.append(
                            EnvelopedVerifier.containsX509Certificate(signature)
                        );
                        buf.append("\n\t");
                        buf.append("Signature verified: ");
                        buf.append(
                            EnvelopedVerifier.verifyElement(elem,signature)
                        );
                        buf.append("\n\t");
                    }
                }
                catch(Exception e){
                    buf.append("Exception received: "+e.getMessage());
                    e.printStackTrace();
                }
                try{
                    // process the assertion
                    Assertion assert = SAMLDeserializer.deserializeAssertion(
                        new DOMTokenizer(elem)
                    );
                    buf.append("Validy interval: ");
                    Conditions conditions = assert.getConditions();
                    if (conditions != null){
                        buf.append("<");
                        buf.append(conditions.getNotBefore().toString());
                        buf.append(",");
                        buf.append(conditions.getNotOnOrAfter().toString());
                        buf.append(")");
                    }
                    else buf.append("unspecified");
                    buf.append("\n\t");
                    buf.append("Issued by: "+assert.getIssuer());
                    buf.append("\n\t");
                    buf.append("Issue Instant Time: "+assert.getIssueInstant());
                    buf.append("\n\t");
                    AuthenticationStatement[] ass = 
                    assert.getAuthenticationStatements();
                    boolean containsAN = ass!=null && ass.length>0;
                    buf.append(
                        "Contains authentication statement: "+ containsAN
                    );
                    if (containsAN){
                      buf.append("\n\t ");
                      buf.append(
                        "authentication method: "+ass[0].getAuthenticationMethod()
                      );
                      buf.append("\n\t ");
                      buf.append("subject:");
                      Subject subject = ass[0].getSubject();
                      if (subject!=null && subject.getSubjectContents()!=null 
                        && subject.getSubjectContents()[0].getNameIdentifier()!=null){
                        NameIdentifier ni = 
                        subject.getSubjectContents()[0].getNameIdentifier();
                        buf.append("\n\t  ");
                        buf.append("name: "+ni.getName());
                        buf.append("\n\t  ");
                        buf.append("security domain: "+ni.getSecurityDomain());
                      }
                    }
                    buf.append("\n");
                }
                catch(Exception e){
                    buf.append("Exception received: "+e.getMessage());
                    e.printStackTrace();
                }
            }
            return buf.toString();
        }
    }
    
    /**
     * verifies the SAML profile
     */
    public boolean verifySAMLProfile() {
        /* 
        	retrieves the SAML assertion from the call context 
        	where it was placed b ythe server-side header processor
        	the header processor is in the WASP Card JARs
        */
        InputSAMLProfile profile = CurrentProfile.getIn(
            CallContext.getInstance()
        );
        // verify all assertions
        if (profile.getAssertionCount()==0){
            return false;
        }
        else{
            int count  = profile.getAssertionCount();
            System.out.println("Count of received Assertions :"+count);
            for(int i=0; i<count; i++){
                System.out.println("Verification of assertion no :"+i);
                Element elem = profile.getDOMAssertion(i);
                try{
                    if (!EnvelopedVerifier.verifyElement(elem)) return false;
                }
                catch(Exception e){
                    e.printStackTrace();
                    return false;
                }
                try{
                    Assertion assert = SAMLDeserializer.deserializeAssertion(
                        new DOMTokenizer(elem)
                    );
                    // verify time constraints
                    return SAMLUtils.isInValidityTime(assert);
                }
                catch(Exception e){
                    e.printStackTrace();
                    return false;
                }
            }
        }
        return false;
    }
}