package com.systinet.demos.saml;

import com.idoox.util.xml.DOMWriter;

import java.io.ByteArrayInputStream;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Document;

import org.idoox.wasp.Context;
import org.idoox.webservice.CallContext;
import org.idoox.webservice.client.WebServiceLookup;
import org.idoox.webservice.client.WebServiceHelper;

import org.systinet.card.CardHelper;
import org.systinet.card.saml.SAMLConstants;
import org.systinet.card.saml.encoding.header.CurrentProfile;
import org.systinet.card.saml.encoding.header.OutputSAMLProfile;
import org.systinet.card.saml.structure.*;
import org.systinet.card.saml.structure.rpc.*;

public class AuthenticatedServiceFrame extends javax.swing.JFrame {

    private OutputSAMLProfile profile;
    
    public AuthenticatedServiceFrame() {
        initComponents();
    }
		
		/**
		 * initializes the GUI
		 */
    private void initComponents() {
        jTextField1 = new javax.swing.JTextField();
        jButton1 = new javax.swing.JButton();
        jTextField2 = new javax.swing.JTextField();
        jButton2 = new javax.swing.JButton();
        jScrollPane1 = new javax.swing.JScrollPane();
        jTextArea1 = new javax.swing.JTextArea();
        jScrollPane2 = new javax.swing.JScrollPane();
        jTextArea2 = new javax.swing.JTextArea();
        jLabel1 = new javax.swing.JLabel();
        jLabel2 = new javax.swing.JLabel();
        jLabel3 = new javax.swing.JLabel();
        jLabel4 = new javax.swing.JLabel();
        jLabel5 = new javax.swing.JLabel();
        jLabel6 = new javax.swing.JLabel();
        jTextField3 = new javax.swing.JTextField();
        jTextField4 = new javax.swing.JTextField();
        
        getContentPane().setLayout(new java.awt.GridBagLayout());
        java.awt.GridBagConstraints gridBagConstraints1;
        
        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosing(java.awt.event.WindowEvent evt) {
                exitForm(evt);
            }
        });
        
        jTextField1.setText("http://localhost:6060/waspcard/samlrpc/");
        gridBagConstraints1 = new java.awt.GridBagConstraints();
        gridBagConstraints1.gridx = 1;
        gridBagConstraints1.gridy = 0;
        gridBagConstraints1.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints1.insets = new java.awt.Insets(5, 5, 5, 5);
        gridBagConstraints1.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints1.weightx = 1.0;
        getContentPane().add(jTextField1, gridBagConstraints1);
        
        jButton1.setText("Get Token");
        jButton1.setMinimumSize(new java.awt.Dimension(81, 21));
        jButton1.setPreferredSize(new java.awt.Dimension(120, 21));
        jButton1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton1ActionPerformed(evt);
            }
        });
        
        gridBagConstraints1 = new java.awt.GridBagConstraints();
        gridBagConstraints1.gridx = 2;
        gridBagConstraints1.gridy = 0;
        gridBagConstraints1.insets = new java.awt.Insets(5, 5, 5, 5);
        gridBagConstraints1.anchor = java.awt.GridBagConstraints.EAST;
        getContentPane().add(jButton1, gridBagConstraints1);
        
        jTextField2.setText("http://localhost:6060/SAMLSSO/");
        gridBagConstraints1 = new java.awt.GridBagConstraints();
        gridBagConstraints1.gridx = 1;
        gridBagConstraints1.gridy = 1;
        gridBagConstraints1.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints1.insets = new java.awt.Insets(5, 5, 5, 5);
        gridBagConstraints1.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints1.weightx = 1.0;
        getContentPane().add(jTextField2, gridBagConstraints1);
        
        jButton2.setText("Call Service");
        jButton2.setMinimumSize(new java.awt.Dimension(81, 21));
        jButton2.setPreferredSize(new java.awt.Dimension(120, 21));
        jButton2.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton2ActionPerformed(evt);
            }
        });
        
        gridBagConstraints1 = new java.awt.GridBagConstraints();
        gridBagConstraints1.gridx = 2;
        gridBagConstraints1.gridy = 1;
        gridBagConstraints1.insets = new java.awt.Insets(5, 5, 5, 5);
        gridBagConstraints1.anchor = java.awt.GridBagConstraints.EAST;
        getContentPane().add(jButton2, gridBagConstraints1);
        
        jScrollPane1.setPreferredSize(new java.awt.Dimension(300, 200));
        jScrollPane1.setViewportView(jTextArea1);
        
        gridBagConstraints1 = new java.awt.GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 6;
        gridBagConstraints1.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints1.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints1.insets = new java.awt.Insets(5, 5, 5, 5);
        gridBagConstraints1.weightx = 100.0;
        gridBagConstraints1.weighty = 100.0;
        getContentPane().add(jScrollPane1, gridBagConstraints1);
        
        jScrollPane2.setPreferredSize(new java.awt.Dimension(300, 200));
        jScrollPane2.setViewportView(jTextArea2);
        
        gridBagConstraints1 = new java.awt.GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 8;
        gridBagConstraints1.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints1.gridheight = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints1.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints1.insets = new java.awt.Insets(5, 5, 5, 5);
        gridBagConstraints1.weightx = 100.0;
        gridBagConstraints1.weighty = 100.0;
        getContentPane().add(jScrollPane2, gridBagConstraints1);
        
        jLabel1.setText("WASP Card URL:");
        gridBagConstraints1 = new java.awt.GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 0;
        gridBagConstraints1.insets = new java.awt.Insets(5, 5, 5, 5);
        gridBagConstraints1.anchor = java.awt.GridBagConstraints.WEST;
        getContentPane().add(jLabel1, gridBagConstraints1);
        
        jLabel2.setText("SAML Response:");
        gridBagConstraints1 = new java.awt.GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 7;
        gridBagConstraints1.insets = new java.awt.Insets(5, 5, 5, 5);
        gridBagConstraints1.anchor = java.awt.GridBagConstraints.WEST;
        getContentPane().add(jLabel2, gridBagConstraints1);
        
        jLabel3.setText("Service URL:");
        gridBagConstraints1 = new java.awt.GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 1;
        gridBagConstraints1.insets = new java.awt.Insets(5, 5, 5, 5);
        gridBagConstraints1.anchor = java.awt.GridBagConstraints.WEST;
        getContentPane().add(jLabel3, gridBagConstraints1);
        
        jLabel4.setText("SAMLRequest:");
        gridBagConstraints1 = new java.awt.GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 5;
        gridBagConstraints1.insets = new java.awt.Insets(5, 5, 5, 5);
        gridBagConstraints1.anchor = java.awt.GridBagConstraints.WEST;
        getContentPane().add(jLabel4, gridBagConstraints1);
        
        jLabel5.setText("Username:");
        gridBagConstraints1 = new java.awt.GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 2;
        gridBagConstraints1.insets = new java.awt.Insets(5, 5, 5, 5);
        gridBagConstraints1.anchor = java.awt.GridBagConstraints.WEST;
        getContentPane().add(jLabel5, gridBagConstraints1);
        
        jLabel6.setText("Password:");
        gridBagConstraints1 = new java.awt.GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 3;
        gridBagConstraints1.insets = new java.awt.Insets(5, 5, 5, 5);
        gridBagConstraints1.anchor = java.awt.GridBagConstraints.WEST;
        getContentPane().add(jLabel6, gridBagConstraints1);
        
        jTextField3.setText("test");
        gridBagConstraints1 = new java.awt.GridBagConstraints();
        gridBagConstraints1.gridx = 1;
        gridBagConstraints1.gridy = 2;
        gridBagConstraints1.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints1.insets = new java.awt.Insets(5, 5, 5, 5);
        gridBagConstraints1.anchor = java.awt.GridBagConstraints.WEST;
        getContentPane().add(jTextField3, gridBagConstraints1);
        
        jTextField4.setText("password");
        gridBagConstraints1 = new java.awt.GridBagConstraints();
        gridBagConstraints1.gridx = 1;
        gridBagConstraints1.gridy = 3;
        gridBagConstraints1.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints1.insets = new java.awt.Insets(5, 5, 5, 5);
        gridBagConstraints1.anchor = java.awt.GridBagConstraints.WEST;
        getContentPane().add(jTextField4, gridBagConstraints1);
        
        pack();
    }

		/*
		 * appends the SAML assertion to the outgoing SOAP messages
		 * and shows the result of the server-side authentication
		 * and verification
		 */
    private void jButton2ActionPerformed(java.awt.event.ActionEvent evt) {
        try {
            WebServiceLookup lookup = (WebServiceLookup)Context.getInstance(
                Context.WEBSERVICE_LOOKUP
            );
            AuthenticatedServiceProxy service = 
            (AuthenticatedServiceProxy)lookup.lookup(
                jTextField2.getText(), AuthenticatedServiceProxy.class
            );
      
            CurrentProfile.setOut(
                this.profile,WebServiceHelper.getCallContext(service)
            );
            
            String result = service.getAuthInfo();
            jLabel4.setText("Authentication Info:");
            jTextArea1.setText(result);
            CurrentProfile.setOut(
                this.profile,WebServiceHelper.getCallContext(service)
            );
            boolean authenticated = service.verifySAMLProfile();
            jTextArea1.append("\n\nAUTHENTICATED: "+authenticated);
            
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
		
		/*
		 * gets the SAML profile
		 */
    private void jButton1ActionPerformed(java.awt.event.ActionEvent evt) {
        try {
            this.getSAMLProfile();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void exitForm(java.awt.event.WindowEvent evt) {
        System.exit(0);
    }

    public static void main(String args[]) {
        new AuthenticatedServiceFrame().show();
    }
    
    /**
     * enhances the XML appearance
     */
    private String beautify(String xml) throws Exception {
        com.idoox.util.xml.XMLSerializer serializer = 
        new com.idoox.util.xml.XMLSerializer(
            new com.idoox.util.xml.OutputFormat(
                com.idoox.util.xml.Method.XML, "UTF-8", true
            )
        );
        java.io.StringWriter writer = new java.io.StringWriter();
        serializer.setOutputCharStream(writer);
        serializer.serialize(getDocument(xml));
        writer.flush();
        writer.close();
        return writer.toString();
    }
    
    /**
     * string -> DOM
     */
    private Document getDocument(String str) throws Exception {
        DocumentBuilderFactory docBF = DocumentBuilderFactory.newInstance();
        docBF.setNamespaceAware(false);
        docBF.setValidating(false);
        DocumentBuilder docB=docBF.newDocumentBuilder();
        
        Document doc=docB.parse(
            new BadCharFilter(new java.io.StringBufferInputStream(str))
        );
        return doc;
    }
    
    /**
     * gets the SAML profile
     */
    private void getSAMLProfile() throws Exception {
        String rpcUrl = jTextField1.getText();
        String identity = jTextField3.getText();
        String password = jTextField4.getText();
        String confMethod = "plain";
        String securityDomain = null;
        
        String[] confirmMethod = new String[1];
        String pass = null;
        // init the password encryption structs
        if (confMethod.equalsIgnoreCase("SHA1")){
            confirmMethod[0] = SAMLConstants.CONFIRM_METHOD_PASSWORD_SHA1;
            pass = new String(
                CardHelper.toBase64(CardHelper.toSHA1(password))
            );
        }
        else if (confMethod.equalsIgnoreCase("plain")){
            confirmMethod[0] = SAMLConstants.CONFIRM_METHOD_PASSWORD;
            pass = new String(CardHelper.toBase64(password));
        }
        // creaet the SAML request
        System.out.println("Constructing SAML request ...");
        SAMLRequest request = new SAMLRequest(); 
        request.setRespondWiths(
            new String[]{SAMLConstants.RESPOND_WITH_AUTHENTICATION}
        );
        // creates the high-level SAML element
        AuthenticationQuery authenticationQuery = new AuthenticationQuery();
        // initializes the confirmation method (password in this case)
        authenticationQuery.setConfirmationMethod(confirmMethod[0]);
        // populates the authentication subject
        Subject subject = new Subject();
        // creates the subject data
        SubjectContent[] subjectContents = new SubjectContent[1];
        SubjectContent subjectContent = new SubjectContent();
        
        NameIdentifier nameIdentifier = new NameIdentifier(
            identity,securityDomain
        );
        subjectContent.setNameIdentifier(nameIdentifier);
        // creates the subject confirmation element
        SubjectConfirmation subjectConfirmation = new SubjectConfirmation();
        subjectConfirmation.setConfirmationMethods(confirmMethod);
        subjectConfirmation.setSubjectConfirmationData(pass);
        
        subjectContent.setSubjectConfirmation(subjectConfirmation);
        subjectContents[0] = subjectContent;
        subject.setSubjectContents(subjectContents);
        
        authenticationQuery.setSubject(subject);
        request.setAuthenticationQuery(authenticationQuery);
        jLabel4.setText("SAML Request:");
        // displays the SAML request
        jTextArea1.setText(beautify(CardHelper.toXML(request)));

        // send SAML request and receive SAML response
        System.out.println("Sending SAML request ... and receving response ...");
        SAMLResponse response = CardHelper.send(rpcUrl, request,false);
        jLabel2.setText("SAML Response:");
        //displays the SAML response
        jTextArea2.setText(beautify(CardHelper.toXML(response)));
				// gets the auth status
        if (!CardHelper.isSuccessful(response)){
            System.out.println();
            System.out.println(
                "The response status code value does not inform about success."
            );
            System.out.println("Test FAILED!");
            return;
        }

        Element domAssert = response.getDomAssertions()[0];
        this.profile = new OutputSAMLProfile();
        this.profile.addDOMAssertion(domAssert);
        
     }


     // Variables declaration - do not modify//GEN-BEGIN:variables
     private javax.swing.JTextField jTextField1;
     private javax.swing.JButton jButton1;
     private javax.swing.JTextField jTextField2;
     private javax.swing.JButton jButton2;
     private javax.swing.JScrollPane jScrollPane1;
     private javax.swing.JTextArea jTextArea1;
     private javax.swing.JScrollPane jScrollPane2;
     private javax.swing.JTextArea jTextArea2;
     private javax.swing.JLabel jLabel1;
     private javax.swing.JLabel jLabel2;
     private javax.swing.JLabel jLabel3;
     private javax.swing.JLabel jLabel4;
     private javax.swing.JLabel jLabel5;
     private javax.swing.JLabel jLabel6;
     private javax.swing.JTextField jTextField3;
     private javax.swing.JTextField jTextField4;
     // End of variables declaration//GEN-END:variables

			/**
			 * filters out the bad chars from the XML
			 */
     private class BadCharFilter extends java.io.FilterInputStream {
        
        public BadCharFilter(java.io.InputStream r) {
            super(r);
        }
         
        public int filter(int c) {
            if(c<32) {
                return '?';
            }
            return c;
        }
             
        public int read() throws java.io.IOException {
            return filter(super.read());
        }
        
        public int read(byte[] b) throws java.io.IOException {
           return read(b, 0, b.length);
        }
        
        public int read(byte[] b, int off, int len) throws java.io.IOException {
            int cnt = super.read(b, off, len);
            for(int i=off;i < off+cnt; i++) {
                b[i] = (byte)filter(b[i]);
            }
            return cnt;
        }
         
     }
}
