package com.systinet.demos.simple;

import java.util.HashMap;

import javax.wsdl.QName;

import org.idoox.webservice.CallContext;
import org.idoox.xmlrpc.Message;
import org.idoox.xmlrpc.header.HeaderProcessingException;
import org.idoox.xmlrpc.header.HeaderProcessor;

import org.idoox.wasp.Context;
import org.idoox.webservice.client.WebServiceLookup;

import org.systinet.card.AuthenticationIface;

import com.systinet.demos.DemoProperties;

public class ClientAuthenticator implements HeaderProcessor{ 
    
    private static byte[] token = null;
    private static String username = null;
    private static String password = null;
    
    public static String USERNAME = "USERNAME";
    public static String PASSWORD = "PASSWORD";
    
    /**
     * appends the token to the SOAP header
     */
    public void processOutput(Message message) throws HeaderProcessingException {
        try {
            // get the username/password from the call context
            CallContext callContext = CallContext.getInstance();
            // did we generate the token in previous call?
            if(token == null) {
                username = (String)callContext.get(USERNAME);
                password = (String)callContext.get(PASSWORD);
                if (username != null) {
                    if(password == null) {
                        password = "";
                    }
 										// lookup the SSO service
                    WebServiceLookup lookup = (WebServiceLookup)Context.getInstance(
                        Context.WEBSERVICE_LOOKUP
                    );
										
                    AuthenticationIface card = 
                    (AuthenticationIface)lookup.lookup(
                        DemoProperties.getProperty("wasp.server.url") + "/waspcard/authentication/", 
                        AuthenticationIface.class
                    );
										// get the auth token
                    token = card.generateAuthenticationToken(
                        username, password
                    );

                    System.out.print("Generating auth token:");
                    for(int i=0; i<Math.min(token.length,10); i++) {
                        System.out.print(token[i]);
                    }
                    System.out.print("...\n");
										// appends the token to the SOAP header
										// prepends it with 'username:'
                    HashMap headerProperties = new HashMap();
                    headerProperties.put(
                        new QName("urn:WaspCard.AuthToken", "AuthToken"), 
                        username+":"+ (new String(token))
                    );

                    message.addHeader(
                        new QName("urn:WaspCard.AuthToken", "AuthenticationInfo"), 
                        headerProperties, 
                        (org.idoox.xml.Tokenizer)null
                    );
                }
            }
            else { // token was already generated, re-using it
            	  
                System.out.print("Reusing auth token:");
                for(int i=0; i<Math.min(token.length,10); i++) {
                    System.out.print(token[i]);
                }
                System.out.print("...\n");
                HashMap headerProperties = new HashMap();
								// appends the token to the SOAP header
								// prepends it with 'username:'
                headerProperties.put(
                    new QName("urn:WaspCard.AuthToken", "AuthToken"), 
                    username+":"+ (new String(token))
                );

                message.addHeader(
                    new QName("urn:WaspCard.AuthToken", "AuthenticationInfo"), 
                    headerProperties, 
                    (org.idoox.xml.Tokenizer)null
                );
            }

        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void processInput(Message message) throws HeaderProcessingException {
	throw new HeaderProcessingException("Unsupported direction");
    }

    public void processInputFault(Message message) throws HeaderProcessingException {
	throw new HeaderProcessingException("Unsupported direction");
    }

    public void processOutputFault(Message message) throws HeaderProcessingException {
	throw new HeaderProcessingException("Unsupported direction");
    }

}