package com.systinet.demos.simple;

import java.util.Map;
import java.util.HashSet;

import javax.wsdl.QName;

import org.idoox.xmlrpc.Constants;
import org.idoox.xmlrpc.Message;
import org.idoox.xmlrpc.MessagePart;
import org.idoox.xmlrpc.header.HeaderProcessingException;
import org.idoox.xmlrpc.header.HeaderProcessor;

import org.idoox.wasp.Context;
import org.idoox.webservice.client.WebServiceLookup;
import org.idoox.webservice.CallContext;
import org.idoox.webservice.client.WebServiceHelper;

import org.idoox.security.AuthResult;
import org.idoox.security.Credentials;
import org.idoox.security.PrincipalAuthenticator;
import org.idoox.security.client.Current;

import org.systinet.card.AuthenticationIface;

import com.systinet.demos.DemoProperties;

public class ServerAuthenticator implements HeaderProcessor {
    
    private static HashSet validTokens = new HashSet();
    
    public static String AUTHENTICATION = "AUTH";
    public static String AUTHENTICATION_OK = "OK";
    public static String AUTHENTICATION_FAIL = "FAIL";
    public static String USERNAME = "USERNAME";
    
    /*
     * processes the input SOAP header
     */
    public void processInput(Message message) throws HeaderProcessingException {
        // get authentication header
        MessagePart header = null;
        int headersCount = message.getHeaderCount();
        for (int i=0; i<headersCount; i++) {
            MessagePart part = message.getHeaderAsPart(i);
            String namespace = part.getPartProperty(Constants.NAMESPACE_PROPERTY);
            String name = part.getPartProperty(Constants.NAME_PROPERTY);
            if (namespace.equals("urn:WaspCard.AuthToken") &&  name.equals("AuthenticationInfo")) {
                header = part;
                break;
            }
        }
				// did we found 'our' header?
        if (header != null) {
            // retrieve username and password from the header
            // and store them in the call context
            CallContext callContext = CallContext.getInstance();
            // gets the token from SOAP header
            String authToken = header.getPartProperty(new QName("urn:WaspCard.AuthToken", "AuthToken"));
            String username = null;
            // strip the username from the token (transferred token has format username:real_token)
            int pos = authToken.indexOf(':');
            if(pos>=0) {
                username = authToken.substring(0, pos);
                authToken = authToken.substring(pos+1);
            }
            if(username != null) {
                callContext.put(USERNAME, username);
            }
            // check the token cache
            if(!validTokens.contains(authToken)) {
                try {
                		// verify the token
                    this.verify(authToken.getBytes());
                    // add the token to the cache
                    validTokens.add(authToken);
                    // put the token to the call context
                    callContext.put(AUTHENTICATION, AUTHENTICATION_OK);
                }
                catch (AuthException e) {
                    e.printStackTrace();
                    callContext.put(AUTHENTICATION, AUTHENTICATION_FAIL);
                }
            }
            else { //cached token
                System.err.println("Cached token found.");
                callContext.put(AUTHENTICATION, AUTHENTICATION_OK);
            }
        }
    }
    
    /**
     * verifies the token
     */
    public void verify(byte[] token) throws AuthException {
        try {
            System.out.print("Validating auth token ");
            for(int i=0; i<Math.min(token.length,10); i++) {
                System.out.print(token[i]);
            }
            System.out.print("...\n\n");
            
            // lookup the SSO web service 
            System.setProperty(
                "wasp.config.include", 
                DemoProperties.getProperty("demo.home") + "/config/client.xml"
            );
            
            WebServiceLookup lookup = (WebServiceLookup)Context.getInstance(
                Context.WEBSERVICE_LOOKUP
            );
            
            // authenticate
            Current current = Current.getInstance();
        
            PrincipalAuthenticator auth = current.getAuthenticator();
            AuthResult result = auth.authenticate("WASP", ("changeit").getBytes());

            if (result.resultCode != AuthResult.AUTH_STATUS_SUCCESS) {
                System.err.println("Unable to authenticate");
                return;
            }
            // assign retrieved credentials with the caller
            current.setCredentials(new Credentials[] { result.creds });
            // lookup the SSO service
            AuthenticationIface card = 
            (AuthenticationIface)lookup.lookup(
                DemoProperties.getProperty("wasp.server.url") + "/waspcard/authentication/", 
                AuthenticationIface.class
            );
            // get the validation status
            if(card.verifyAuthenticationToken(token) == AuthenticationIface.VER_FAILURE) {
                throw new AuthException(
                    "Authentication failed."
                );
            }
            
        }
        catch (AuthException e) {
            e.printStackTrace();
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new  AuthException(
                "Auth subsystem error: "+e
            );
        }
    }

    public void processOutput(Message message) throws HeaderProcessingException {
	throw new HeaderProcessingException("Unsupported direction");
    }

    public void processInputFault(Message message) throws HeaderProcessingException {
	throw new HeaderProcessingException("Unsupported direction");
    }

    public void processOutputFault(Message message) throws HeaderProcessingException {
	throw new HeaderProcessingException("Unsupported direction");
    }

}