package com.systinet.demos.simple;

import org.idoox.wasp.Context;
import org.idoox.webservice.client.WebServiceLookup;
import org.idoox.webservice.client.WebServiceHelper;
import org.idoox.webservice.CallContext;

import org.idoox.security.AuthResult;
import org.idoox.security.Credentials;
import org.idoox.security.PrincipalAuthenticator;
import org.idoox.security.client.Current;

import com.systinet.demos.DemoProperties;

public final class StockClient {

    public static void main( String[] args ) throws Exception {
        
        //gets the username/password from cmdline params
        String username = "test";
        String password = "password";
        if(args.length > 0 && args[0] != null) {
            username = args[0];
        }
        
        if(args.length > 1 && args[1] != null) {
            password = args[1];
        }
        // lookup the stock quoute service
        WebServiceLookup lookup = (WebServiceLookup)Context.getInstance(
            Context.WEBSERVICE_LOOKUP
        );
				// authenticate
        Current current = Current.getInstance();
        
        PrincipalAuthenticator auth = current.getAuthenticator();
        AuthResult result = auth.authenticate("admin", ("changeit").getBytes());

        if (result.resultCode != AuthResult.AUTH_STATUS_SUCCESS) {
            System.err.println("Unable to authenticate");
            return;
        }
        current.setCredentials(new Credentials[] { result.creds });

        // bind to StockQuoteService
        StockProxy quoteService = (StockProxy)lookup.lookup(
            "http://localhost:6060/SimpleSSO/", 
            StockProxy.class
        );
        // get the call context
        CallContext callContext = WebServiceHelper.getCallContext(quoteService);
        // store username/password in the call context
        callContext.put(ClientAuthenticator.USERNAME, username);
        callContext.put(ClientAuthenticator.PASSWORD, password);
        
        // use StockQuoteService
        System.out.println("Getting SUNW quote");
        System.out.println("------------------\n\n");
        System.out.println("SUNW "+
            quoteService.getQuote("SUNW")
        );
        
        System.out.println("BEAS "+
            quoteService.getQuote("BEAS")
        );
        System.out.println("");

    }

}