package com.systinet.demos.fault.client;

import org.idoox.wasp.Context;
import org.idoox.webservice.client.WebServiceLookup;

public final class StockQuoteClient {

    public static void main( String[] args ) throws Exception {
        
      // lookup service
      WebServiceLookup lookup = (WebServiceLookup)Context.getInstance(Context.WEBSERVICE_LOOKUP);
      // bind to StockQuoteService
      StockQuoteService service = (StockQuoteService)lookup.lookup(
        "http://localhost:6060/Fault/",
        StockQuoteService.class
      );
      

      // use StockQuoteService
      System.out.println("Getting available stocks");
      System.out.println("------------------------");
      java.util.LinkedList list = service.getAvailableStocks();
      java.util.Iterator iter = list.iterator();
      while(iter.hasNext()) {
         System.out.println(iter.next());
      }
      System.out.println("");
      
      System.out.println("Getting SUNW quote");
      System.out.println("------------------------");
      System.out.println("SUNW "+service.getQuote("SUNW"));
      System.out.println("");
      
      System.out.println("Getting IBM quote (warning, this one doesn't exists, so we will get an exception)");
      System.out.println("------------------------");
      System.out.println("IBM "+service.getQuote("IBM"));
      System.out.println("");

      
    }

}