/**
 * Stock Client
 *
 * @created July 17, 2001
 * @author zdenek
 */

package com.systinet.demos.stock.client;

import org.idoox.wasp.Context;
import org.idoox.webservice.client.WebServiceLookup;

public class StockQuoteClient {

  /**
   * Web service client main method.
   * Finds the web service and 
   * @param args  not used.
   */
    public static void main( String[] args ) throws Exception {
        
      // lookup service
      WebServiceLookup lookup = (WebServiceLookup)Context.getInstance(Context.WEBSERVICE_LOOKUP);
      // bind to StockQuoteService
      StockQuoteService service = (StockQuoteService)lookup.lookup(
        "http://localhost:6060/StockQuoteService/",
        StockQuoteService.class
      );
      

      // use StockQuoteService
      System.out.println("Getting available stocks");
      System.out.println("------------------------");
      java.util.LinkedList list = service.getAvailableStocks();
      java.util.Iterator iter = list.iterator();
      while(iter.hasNext()) {
         System.out.println(iter.next());
      }
      System.out.println("");
      
      System.out.println("Getting SUNW quote");
      System.out.println("------------------------");
      System.out.println("SUNW "+service.getQuote("SUNW"));
      System.out.println("");
      
    }

}