package demo.freedb;

/**
 * Represents the CD record
 * @author Zdenek Svoboda
 * @version 1.0
 */
public class CDRecord {

	/** Holds value of property title. */
	private String title;	
    
	/** Holds value of property discId. */
	private String discId;
	
	/** Holds value of property category. */
	private String category;
	
	/** Holds value of property songs. */
	private String[] songs;
	
	/** Holds value of property author. */
	private String author;
	
	/** Getter for property title.
	 * @return Value of property title.
	 */
	public String getTitle() {
		return this.title;
	}	

	/** Setter for property title.
	 * @param title New value of property title.
	 */
	public void setTitle(String title) {
		this.title = title;
	}
	
	/** Getter for property discId.
	 * @return Value of property discId.
	 */
	public String getDiscId() {
		return this.discId;
	}
	
	/** Setter for property discId.
	 * @param discId New value of property discId.
	 */
	public void setDiscId(String discId) {
		this.discId = discId;
	}
	
	/** Getter for property category.
	 * @return Value of property category.
	 */
	public String getCategory() {
		return this.category;
	}
	
	/** Setter for property category.
	 * @param category New value of property category.
	 */
	public void setCategory(String category) {
		this.category = category;
	}
	
	/** Indexed getter for property songs.
	 * @param index Index of the property.
	 * @return Value of the property at <CODE>index</CODE>.
	 */
	public String getSongs(int index) {
		return this.songs[index];
	}
	
	/** Getter for property songs.
	 * @return Value of property songs.
	 */
	public String[] getSongs() {
		return this.songs;
	}
	
	/** Indexed setter for property songs.
	 * @param index Index of the property.
	 * @param songs New value of the property at <CODE>index</CODE>.
	 */
	public void setSongs(int index, String songs) {
		this.songs[index] = songs;
	}
	
	/** Setter for property songs.
	 * @param songs New value of property songs.
	 */
	public void setSongs(String[] songs) {
		this.songs = songs;
	}
		
	/** Getter for property author.
	 * @return Value of property author.
	 */
	public String getAuthor() {
		return this.author;
	}
	
	/** Setter for property author.
	 * @param author New value of property author.
	 */
	public void setAuthor(String author) {
		this.author = author;
	}
	
	/**
	 * Returns String representation of the CDRecord
	 * @return  String representation of the CDRecord
	 */	
	public String toString() {
		String result = "Title: "+this.title+
		"\nAuthor: "+this.author+
		"\nCD #: "+this.discId+
		"\nCategory: "+this.category+
		"\nSongs:\n";
		if(this.songs != null) {
			for(int i=0; i<this.songs.length; i++) {
				result += (i+1)+". "+this.songs[i]+"\n";
			}
		}
		return result;
	}

	
}