/*
 * CDRecordTreeNode.java
 *
 * Created on March 14, 2002, 3:31 PM
 */

package demo.freedb;

/**
 *
 * @author  Zdenek Svoboda
 */
public class CDRecordTreeNode implements javax.swing.tree.TreeNode {
        
     private CDRecord record = null;
     private java.util.Vector children = new java.util.Vector();
     private CDRecordTreeNode parent = null;
     private String song = null;
		 private boolean topLevel = false;
		 
     public CDRecordTreeNode(CDRecord[] records) {
				try {
            this.topLevel = true;
						this.song = "Results";
						if(records != null) {
							for(int i=0; i<records.length; i++) {
								this.addChild(new CDRecordTreeNode(this, records[i]));
							}
						}
        }
        catch (Exception e) {
            e.printStackTrace();
        }
     }

     public CDRecordTreeNode(CDRecordTreeNode parent, CDRecord record) {
        this.record = record;
				this.parent = parent;
				String[] songs = record.getSongs();
				for(int i=0; i<songs.length; i++) {
					this.addChild(new CDRecordTreeNode(this, (i+1)+". "+songs[i]));
				}
     }
     
     public CDRecordTreeNode(CDRecordTreeNode parent, String song) {
        this.song = song;
        this.parent = parent;
     }

     public java.util.Enumeration children() {
        return this.children.elements();
     }     

     public boolean getAllowsChildren() {
        if((this.topLevel) || (this.record != null)) {
            return true;
        }
        return false;
     }     

     public javax.swing.tree.TreeNode getChildAt(int param) {
         return (javax.swing.tree.TreeNode)this.children.elementAt(param);
     }

     public int getChildCount() {
			return this.children.size();
     }

     public int getIndex(javax.swing.tree.TreeNode treeNode) {
         return this.children.indexOf(treeNode);
     }

     public javax.swing.tree.TreeNode getParent() {
         return this.parent;
     }

     public boolean isLeaf() {
			 
        if((this.topLevel) || (this.record != null)) {
            return false;
        }
        return true;
     }

     public void addChild(CDRecordTreeNode child) {
        this.children.add(child);
     }

     public boolean removeChild(CDRecordTreeNode child) {
        return this.children.remove(child);
     }

     public String toString() {
       if(this.record != null) {
				return this.record.getAuthor()+" : "+this.record.getTitle();
			 }
			 else {
				return this.song;
			 }
     }

}