package demo.freedb;

// imports of WASP classes
import org.idoox.webservice.client.WebServiceLookup;
import org.idoox.wasp.Context;

/**
 * Music service factory that uses hard coded values
 * @author  Zdenek Svoboda
 */
public class HardCodedMusicServiceFactory implements MusicServiceFactory {
	
	/**
	 * Creates the new music srvice instance
	 * @param params parameters
	 * @return Music service instance
	 * @throws Exception if any error occurs
	 */
	public MusicService createMusicService(java.util.Map params) throws Exception {
		// get the lookup object
		WebServiceLookup lookup = (WebServiceLookup) Context.getInstance(Context.WEBSERVICE_LOOKUP);
		// get the proxy to the Web Service from the lookup
		return (MusicService)lookup.lookup((String)params.get(MusicServiceFactory.PARAM_DIRECT_URL), MusicService.class);
	}
	
}
