/*
 * JUDDIRegister.java
 *
 * Created on March 14, 2002, 7:33 PM
 */

package demo.uddi;

import org.idoox.uddi.client.structure.v2.business.BusinessKey;
import org.idoox.uddi.client.structure.v2.tmodel.TModelKey;
import org.idoox.uddi.client.structure.v2.service.ServiceKey;
import org.idoox.uddi.client.structure.v2.binding.BindingKey;
import org.idoox.uddi.client.structure.v2.binding.AccessPoint;
import org.idoox.uddi.client.structure.v2.base.URLType;


/**
 *
 * @author  Zdenek Svoboda
 */
public class JUDDIRegister extends javax.swing.JFrame {
	
	/** Creates new form JUDDIRegister */
	public JUDDIRegister() {
		initComponents();
	}
	
	/** This method is called from within the constructor to
	 * initialize the form.
	 * WARNING: Do NOT modify this code. The content of this method is
	 * always regenerated by the Form Editor.
	 */
  private void initComponents() {//GEN-BEGIN:initComponents
    java.awt.GridBagConstraints gridBagConstraints;

    jLabel1 = new javax.swing.JLabel();
    jTextFieldPublishURL = new javax.swing.JTextField();
    jLabel2 = new javax.swing.JLabel();
    jTextFieldUsername = new javax.swing.JTextField();
    jLabel3 = new javax.swing.JLabel();
    jTextFieldPassword = new javax.swing.JTextField();
    jLabel4 = new javax.swing.JLabel();
    jTextFieldBusinessName = new javax.swing.JTextField();
    jLabel5 = new javax.swing.JLabel();
    jTextFieldServiceName = new javax.swing.JTextField();
    jLabel6 = new javax.swing.JLabel();
    jTextFieldWSDLURL = new javax.swing.JTextField();
    jLabel61 = new javax.swing.JLabel();
    jTextFieldAccessPoint = new javax.swing.JTextField();
    jButton1 = new javax.swing.JButton();
    jLabel41 = new javax.swing.JLabel();
    jTextFieldTModelName = new javax.swing.JTextField();

    getContentPane().setLayout(new java.awt.GridBagLayout());

    addWindowListener(new java.awt.event.WindowAdapter() {
      public void windowClosing(java.awt.event.WindowEvent evt) {
        exitForm(evt);
      }
    });

    jLabel1.setText("Publishing URL:");
    gridBagConstraints = new java.awt.GridBagConstraints();
    gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
    gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
    getContentPane().add(jLabel1, gridBagConstraints);

    jTextFieldPublishURL.setEditable(false);
    jTextFieldPublishURL.setText("https://www.systinet.com:443/uddi/publishing");
    jTextFieldPublishURL.setPreferredSize(new java.awt.Dimension(500, 21));
    gridBagConstraints = new java.awt.GridBagConstraints();
    gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
    gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
    gridBagConstraints.weightx = 1.0;
    gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
    getContentPane().add(jTextFieldPublishURL, gridBagConstraints);

    jLabel2.setText("Username:");
    gridBagConstraints = new java.awt.GridBagConstraints();
    gridBagConstraints.gridx = 0;
    gridBagConstraints.gridy = 1;
    gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
    gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
    getContentPane().add(jLabel2, gridBagConstraints);

    jTextFieldUsername.setPreferredSize(new java.awt.Dimension(500, 21));
    gridBagConstraints = new java.awt.GridBagConstraints();
    gridBagConstraints.gridx = 1;
    gridBagConstraints.gridy = 1;
    gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
    gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
    gridBagConstraints.weightx = 1.0;
    gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
    getContentPane().add(jTextFieldUsername, gridBagConstraints);

    jLabel3.setText("Password:");
    gridBagConstraints = new java.awt.GridBagConstraints();
    gridBagConstraints.gridx = 0;
    gridBagConstraints.gridy = 2;
    gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
    gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
    getContentPane().add(jLabel3, gridBagConstraints);

    jTextFieldPassword.setPreferredSize(new java.awt.Dimension(500, 21));
    gridBagConstraints = new java.awt.GridBagConstraints();
    gridBagConstraints.gridx = 1;
    gridBagConstraints.gridy = 2;
    gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
    gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
    gridBagConstraints.weightx = 1.0;
    gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
    getContentPane().add(jTextFieldPassword, gridBagConstraints);

    jLabel4.setText("Business Name:");
    gridBagConstraints = new java.awt.GridBagConstraints();
    gridBagConstraints.gridx = 0;
    gridBagConstraints.gridy = 4;
    gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
    gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
    getContentPane().add(jLabel4, gridBagConstraints);

    jTextFieldBusinessName.setPreferredSize(new java.awt.Dimension(500, 21));
    jTextFieldBusinessName.addFocusListener(new java.awt.event.FocusAdapter() {
      public void focusLost(java.awt.event.FocusEvent evt) {
        jTextFieldBusinessNameFocusLost(evt);
      }
    });

    jTextFieldBusinessName.addInputMethodListener(new java.awt.event.InputMethodListener() {
      public void inputMethodTextChanged(java.awt.event.InputMethodEvent evt) {
        jTextFieldBusinessNameInputMethodTextChanged(evt);
      }
      public void caretPositionChanged(java.awt.event.InputMethodEvent evt) {
        jTextFieldBusinessNameCaretPositionChanged(evt);
      }
    });

    jTextFieldBusinessName.addPropertyChangeListener(new java.beans.PropertyChangeListener() {
      public void propertyChange(java.beans.PropertyChangeEvent evt) {
        jTextFieldBusinessNamePropertyChange(evt);
      }
    });

    gridBagConstraints = new java.awt.GridBagConstraints();
    gridBagConstraints.gridx = 1;
    gridBagConstraints.gridy = 4;
    gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
    gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
    gridBagConstraints.weightx = 1.0;
    gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
    getContentPane().add(jTextFieldBusinessName, gridBagConstraints);

    jLabel5.setText("Service Name:");
    gridBagConstraints = new java.awt.GridBagConstraints();
    gridBagConstraints.gridx = 0;
    gridBagConstraints.gridy = 5;
    gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
    gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
    getContentPane().add(jLabel5, gridBagConstraints);

    jTextFieldServiceName.setEditable(false);
    jTextFieldServiceName.setText("MusicService");
    jTextFieldServiceName.setPreferredSize(new java.awt.Dimension(500, 21));
    gridBagConstraints = new java.awt.GridBagConstraints();
    gridBagConstraints.gridx = 1;
    gridBagConstraints.gridy = 5;
    gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
    gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
    gridBagConstraints.weightx = 1.0;
    gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
    getContentPane().add(jTextFieldServiceName, gridBagConstraints);

    jLabel6.setText("WSDL URL:");
    gridBagConstraints = new java.awt.GridBagConstraints();
    gridBagConstraints.gridx = 0;
    gridBagConstraints.gridy = 7;
    gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
    gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
    getContentPane().add(jLabel6, gridBagConstraints);

    jTextFieldWSDLURL.setEditable(false);
    jTextFieldWSDLURL.setText("http://soap.systinet.net/ws/FreeDbService/");
    jTextFieldWSDLURL.setPreferredSize(new java.awt.Dimension(500, 21));
    gridBagConstraints = new java.awt.GridBagConstraints();
    gridBagConstraints.gridx = 1;
    gridBagConstraints.gridy = 7;
    gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
    gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
    gridBagConstraints.weightx = 1.0;
    gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
    getContentPane().add(jTextFieldWSDLURL, gridBagConstraints);

    jLabel61.setText("Access Point:");
    gridBagConstraints = new java.awt.GridBagConstraints();
    gridBagConstraints.gridx = 0;
    gridBagConstraints.gridy = 6;
    gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
    gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
    getContentPane().add(jLabel61, gridBagConstraints);

    jTextFieldAccessPoint.setEditable(false);
    jTextFieldAccessPoint.setText("http://soap.systinet.net/ws/FreeDbService/");
    jTextFieldAccessPoint.setPreferredSize(new java.awt.Dimension(500, 21));
    gridBagConstraints = new java.awt.GridBagConstraints();
    gridBagConstraints.gridx = 1;
    gridBagConstraints.gridy = 6;
    gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
    gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
    gridBagConstraints.weightx = 1.0;
    gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
    getContentPane().add(jTextFieldAccessPoint, gridBagConstraints);

    jButton1.setText("Publish");
    jButton1.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        jButton1ActionPerformed(evt);
      }
    });

    gridBagConstraints = new java.awt.GridBagConstraints();
    gridBagConstraints.gridx = 1;
    gridBagConstraints.gridy = 8;
    gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
    gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
    getContentPane().add(jButton1, gridBagConstraints);

    jLabel41.setText("tModel Name:");
    gridBagConstraints = new java.awt.GridBagConstraints();
    gridBagConstraints.gridx = 0;
    gridBagConstraints.gridy = 3;
    gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
    gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
    getContentPane().add(jLabel41, gridBagConstraints);

    jTextFieldTModelName.setEditable(false);
    jTextFieldTModelName.setText("MusicService");
    jTextFieldTModelName.setPreferredSize(new java.awt.Dimension(500, 21));
    gridBagConstraints = new java.awt.GridBagConstraints();
    gridBagConstraints.gridx = 1;
    gridBagConstraints.gridy = 3;
    gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
    gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
    gridBagConstraints.weightx = 1.0;
    gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
    getContentPane().add(jTextFieldTModelName, gridBagConstraints);

    pack();
  }//GEN-END:initComponents

	private void jTextFieldBusinessNameFocusLost(java.awt.event.FocusEvent evt) {//GEN-FIRST:event_jTextFieldBusinessNameFocusLost
		this.jTextFieldTModelName.setText(
			"MusicServiceTypefor"+this.jTextFieldBusinessName.getText()
		);
	}//GEN-LAST:event_jTextFieldBusinessNameFocusLost

	private void jTextFieldBusinessNameCaretPositionChanged(java.awt.event.InputMethodEvent evt) {//GEN-FIRST:event_jTextFieldBusinessNameCaretPositionChanged
		
	}//GEN-LAST:event_jTextFieldBusinessNameCaretPositionChanged

	private void jTextFieldBusinessNameInputMethodTextChanged(java.awt.event.InputMethodEvent evt) {//GEN-FIRST:event_jTextFieldBusinessNameInputMethodTextChanged
		
	}//GEN-LAST:event_jTextFieldBusinessNameInputMethodTextChanged

	private void jTextFieldBusinessNamePropertyChange(java.beans.PropertyChangeEvent evt) {//GEN-FIRST:event_jTextFieldBusinessNamePropertyChange
		
	}//GEN-LAST:event_jTextFieldBusinessNamePropertyChange

	private void jButton1ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton1ActionPerformed
		
		try {
			UDDIPublish publisher = new UDDIPublish(
				this.jTextFieldPublishURL.getText(),
				this.jTextFieldUsername.getText(),
				this.jTextFieldPassword.getText()
			);
			
			TModelKey tmodelKey = publisher.saveTModel(
				"MusicServicefor"+this.jTextFieldBusinessName.getText(),
				this.jTextFieldWSDLURL.getText()
			);
			
			BusinessKey businessKey = publisher.saveBusiness(
				this.jTextFieldBusinessName.getText()
			);
			
			ServiceKey serviceKey = publisher.saveService(
				businessKey,
				this.jTextFieldServiceName.getText()
			);
			
			
			BindingKey bindingKey = publisher.saveBinding(
				serviceKey,
				tmodelKey,
				new AccessPoint(
					new URLType(URLType.URL_TYPE_HTTP),
					this.jTextFieldAccessPoint.getText()
				)
			);
			
		}
		catch (Exception e) {
			e.printStackTrace();
		}
		
	}//GEN-LAST:event_jButton1ActionPerformed
	
	/** Exit the Application */
	private void exitForm(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_exitForm
		System.exit(0);
	}//GEN-LAST:event_exitForm
	
	/**
	 * @param args the command line arguments
	 */
	public static void main(String args[]) {
		new JUDDIRegister().show();
	}
	
	
  // Variables declaration - do not modify//GEN-BEGIN:variables
  private javax.swing.JLabel jLabel41;
  private javax.swing.JTextField jTextFieldAccessPoint;
  private javax.swing.JTextField jTextFieldPublishURL;
  private javax.swing.JTextField jTextFieldPassword;
  private javax.swing.JTextField jTextFieldWSDLURL;
  private javax.swing.JTextField jTextFieldUsername;
  private javax.swing.JButton jButton1;
  private javax.swing.JLabel jLabel6;
  private javax.swing.JLabel jLabel5;
  private javax.swing.JLabel jLabel4;
  private javax.swing.JLabel jLabel3;
  private javax.swing.JLabel jLabel2;
  private javax.swing.JTextField jTextFieldServiceName;
  private javax.swing.JLabel jLabel1;
  private javax.swing.JLabel jLabel61;
  private javax.swing.JTextField jTextFieldBusinessName;
  private javax.swing.JTextField jTextFieldTModelName;
  // End of variables declaration//GEN-END:variables
	
}
