package demo.uddi;

import org.idoox.uddi.client.api.v2.request.publishing.GetAuthToken;
import org.idoox.uddi.client.api.v2.request.publishing.DiscardAuthToken;
import org.idoox.uddi.client.api.v2.request.publishing.UserID;
import org.idoox.uddi.client.api.v2.request.publishing.Cred;

import org.idoox.uddi.client.api.v2.request.publishing.SaveBusiness;
import org.idoox.uddi.client.api.v2.request.publishing.SaveTModel;
import org.idoox.uddi.client.api.v2.request.publishing.SaveService;
import org.idoox.uddi.client.api.v2.request.publishing.SaveBinding;

import org.idoox.uddi.client.structure.v2.business.BusinessEntities;
import org.idoox.uddi.client.structure.v2.business.BusinessEntity;
import org.idoox.uddi.client.structure.v2.business.BusinessKey;

import org.idoox.uddi.client.structure.v2.tmodel.TModels;
import org.idoox.uddi.client.structure.v2.tmodel.TModel;
import org.idoox.uddi.client.structure.v2.tmodel.TModelKey;

import org.idoox.uddi.client.structure.v2.service.BusinessServices;
import org.idoox.uddi.client.structure.v2.service.BusinessService;
import org.idoox.uddi.client.structure.v2.service.ServiceKey;

import org.idoox.uddi.client.structure.v2.binding.BindingTemplates;
import org.idoox.uddi.client.structure.v2.binding.BindingTemplate;
import org.idoox.uddi.client.structure.v2.binding.BindingKey;
import org.idoox.uddi.client.structure.v2.binding.InstanceDetails;
import org.idoox.uddi.client.structure.v2.binding.AccessPoint;
import org.idoox.uddi.client.structure.v2.binding.TModelInstanceInfo;
import org.idoox.uddi.client.structure.v2.binding.TModelInstanceDetails;

import org.idoox.uddi.client.structure.v2.base.Description;
import org.idoox.uddi.client.structure.v2.base.Name;
import org.idoox.uddi.client.structure.v2.base.OverviewDoc;
import org.idoox.uddi.client.structure.v2.base.OverviewURL;
import org.idoox.uddi.client.structure.v2.base.CategoryBag;
import org.idoox.uddi.client.structure.v2.base.KeyedReferences;
import org.idoox.uddi.client.structure.v2.base.KeyedReference;
import org.idoox.uddi.client.structure.v2.base.KeyName;
import org.idoox.uddi.client.structure.v2.base.KeyValue;

import org.idoox.uddi.client.api.v2.response.AuthToken;
import org.idoox.uddi.client.api.v2.response.BusinessDetail;
import org.idoox.uddi.client.api.v2.response.TModelDetail;
import org.idoox.uddi.client.api.v2.response.ServiceDetail;
import org.idoox.uddi.client.api.v2.response.BindingDetail;

import org.idoox.uddi.client.api.v2.UDDIApiPublishing;
import org.idoox.uddi.client.api.v2.UDDILookup;

import org.idoox.uddi.UDDIErrorCodes;
import org.idoox.uddi.NameTooLongException;
import org.idoox.uddi.UDDIException;

/**
 * This is simple standalone example of the UDDIv2 API call save_business.
 * <BR>
 * For more complex examples see the demo suite. 
 */
public class UDDIPublish {

	/** UDDIv2 publishing stub */
	private UDDIApiPublishing publishing;
	
	/** UDDIv2 authentication token */
	private AuthToken authToken;
	
	public UDDIPublish(String uddiURL, String username, String password) {
		try {
			// SSL related properties must be set.
			System.setProperty("java.protocol.handler.pkgs", "com.sun.net.ssl.internal.www.protocol");
			System.setProperty("wasp.restrictor.packages","-");
			// Get the UDDIv2 publishing stub for particular URL to invoke the save_business call.
			publishing = UDDILookup.getPublishing(uddiURL);
			// creating AuthToken structure that contains login information
			authToken = publishing.get_authToken(new GetAuthToken(new UserID(username), new Cred(password)));
		}
		catch (Exception e) {
			e.printStackTrace();
		}
	}
	
	/**
	 * The UDDI API call <code>save_business</code>.
	 */
	public BusinessKey saveBusiness(String businessName) throws Exception {
		// New business entity structure.
		BusinessEntity businessEntity = new BusinessEntity();
		// Set empty business key (create)
    businessEntity.setBusinessKey(new BusinessKey(""));
		// Add name with default language code.
		businessEntity.addName(new Name(businessName));
		// Setting description of the business which will be saved.
		businessEntity.addDescription(new Description("This is example business published by TheServerSide example."));
		// Save business message.
		SaveBusiness saveBusiness = new SaveBusiness();
		// Setting login information as AuthInfo structure.
		saveBusiness.setAuthInfo(authToken.getAuthInfo());
		// Adding business entity which will be saved.
		saveBusiness.addBusinessEntity(businessEntity);
		// Lets save the new business.
		BusinessDetail businessDetail = publishing.save_business(saveBusiness);
		BusinessEntities businessEntities = businessDetail.getBusinessEntities();
	  businessEntity = businessEntities.getFirst();
		return businessEntity.getBusinessKey();
	}
	
	public TModelKey saveTModel(String name, String wsdlURL) throws Exception{
		// new tModel structure
		TModel tModel = new TModel();
		// Set empty tModel key (create)
    tModel.setTModelKey(new TModelKey(""));
		// setting tModel name
		tModel.setName(new Name(name));
		// setting the OverviewDoc tha contains the WSDL URL 
		// see http://uddi.org/pubs/wsdlbestpractices-V1.06-Open-20011130.pdf for more details
		OverviewDoc od = new OverviewDoc();
		od.setOverviewURL(new OverviewURL(wsdlURL));
		tModel.setOverviewDoc(od);
		
		// set the mandatory category bag for WSDL 
		// see http://uddi.org/pubs/wsdlbestpractices-V1.06-Open-20011130.pdf for more details
		CategoryBag cb = new CategoryBag();
		KeyedReferences krs = new KeyedReferences();
		KeyedReference kr = new KeyedReference(
			new TModelKey("uuid:c1acf26d-9672-4404-9d70-39b756e62ab4"), 
			new KeyName("uddi-org:types"), 
			new KeyValue("wsdlSpec")
		);
		krs.add(kr);
		cb.setKeyedReferences(krs);
		tModel.setCategoryBag(cb);
		
		// setting description of the tModel which will be saved
		tModel.addDescription(new Description("This is example tModel published by TheServerSide example."));
		// new save tModel structure
		SaveTModel saveTModel = new SaveTModel();
		// setting login information as AuthInfo structure
		saveTModel.setAuthInfo(authToken.getAuthInfo());
		// adding tModel which will be saved
		saveTModel.addTModel(tModel);
		// calling API method save_tModel and obtaining result in TModelDetail structure
		TModelDetail tModelDetail = publishing.save_tModel(saveTModel);

	  TModels tModels = tModelDetail.getTModels();
	  tModel = tModels.getFirst();
		return tModel.getTModelKey();
  }
	
	public ServiceKey saveService(BusinessKey businessKey, String name) throws Exception {
		if (businessKey == null){
				System.out.println("ERROR: Null businessKey");
				System.exit(1);
		}

		// new business service structure
		BusinessService businessService = new BusinessService();
		// Set empty service key (create)
    businessService.setServiceKey(new ServiceKey(""));
		// setting business entity key
		businessService.setBusinessKey(businessKey);
		// setting business service names
		businessService.addName(new Name(name));
		// setting description of the service which will be saved
		businessService.addDescription(new Description("This is example service published by TheServerSide example."));
		// new save business structure
		SaveService saveService = new SaveService();
		// setting login information as AuthInfo structure
		saveService.setAuthInfo(authToken.getAuthInfo());
		// adding business entity which will be saved
		saveService.addBusinessService(businessService);
		// calling the API method save_business and obtaining the result in ServiceDetail structure
		ServiceDetail serviceDetail = publishing.save_service(saveService);
		// parsing business detail
		BusinessServices businessServices = serviceDetail.getBusinessServices();
		businessService = businessServices.getFirst();
		return businessService.getServiceKey();

	}
	
	public BindingKey saveBinding(ServiceKey serviceKey, TModelKey tModelKey, AccessPoint accessPoint)  throws Exception{
		if (serviceKey == null){
				System.out.println("ERROR: Null serviceKey");
				System.exit(1);
		}
		if (tModelKey == null){
				System.out.println("ERROR: Null tModelKey");
				System.exit(1);
		}

		// new binding template structure
		BindingTemplate bindingTemplate = new BindingTemplate();
		// Set empty binding key (create)
    bindingTemplate.setBindingKey(new BindingKey(""));
		// setting service key
		bindingTemplate.setServiceKey(serviceKey);
		// setting access point
		bindingTemplate.setAccessPoint(accessPoint);
		// setting description of the binding which will be saved
		bindingTemplate.addDescription(new Description("This is example binding published by TheServerSide example."));

		// new instance info for a tModelKey
		TModelInstanceInfo info=new TModelInstanceInfo();
		info.setTModelKey(tModelKey);

		TModelInstanceDetails details=new TModelInstanceDetails();
		details.add(info);
		// instance detail with instance info
		bindingTemplate.setTModelInstanceDetails(details);

		// new save binding structure
		SaveBinding saveBinding = new SaveBinding();
		// setting login information as AuthInfo structure
		saveBinding.setAuthInfo(authToken.getAuthInfo());
		// adding bindingTemplate which will be saved
		saveBinding.addBindingTemplate(bindingTemplate);

		// calling API method save_business and obtaining the result in BindingDetail structure
		BindingDetail bindingDetail = publishing.save_binding(saveBinding);

	  // parsing binding detail
	  BindingTemplates bindingTemplates = bindingDetail.getBindingTemplates();
	  bindingTemplate = bindingTemplates.getFirst();
	  return bindingTemplate.getBindingKey();
	}

}