package demo.uddi;

import org.idoox.uddi.UDDIErrorCodes;
import org.idoox.uddi.UDDIException;

import org.idoox.uddi.client.structure.v2.base.KeyedReference;
import org.idoox.uddi.client.structure.v2.base.Name;
import org.idoox.uddi.client.structure.v2.business.DiscoveryURL;

import org.idoox.uddi.client.structure.v2.business.BusinessKey;
import org.idoox.uddi.client.structure.v2.service.ServiceKey;
import org.idoox.uddi.client.structure.v2.tmodel.TModelKey;
import org.idoox.uddi.client.structure.v2.binding.BindingKey;
import org.idoox.uddi.client.structure.v2.binding.BindingTemplate;

import org.idoox.uddi.client.api.v2.UDDILookup;
import org.idoox.uddi.client.api.v2.UDDIApiInquiry;

import org.idoox.uddi.client.api.v2.request.inquiry.FindTModel;
import org.idoox.uddi.client.api.v2.request.inquiry.FindBusiness;
import org.idoox.uddi.client.api.v2.request.inquiry.FindService;
import org.idoox.uddi.client.api.v2.request.inquiry.FindBinding;
import org.idoox.uddi.client.api.v2.request.inquiry.GetBusinessDetail;
import org.idoox.uddi.client.api.v2.request.inquiry.GetServiceDetail;
import org.idoox.uddi.client.api.v2.request.inquiry.GetTModelDetail;
import org.idoox.uddi.client.api.v2.request.inquiry.GetBindingDetail;

import org.idoox.uddi.client.api.v2.request.inquiry.MaxRows;

import org.idoox.uddi.client.api.v2.response.BusinessInfo;
import org.idoox.uddi.client.api.v2.response.BusinessList;
import org.idoox.uddi.client.api.v2.response.ServiceInfo;
import org.idoox.uddi.client.api.v2.response.ServiceList;
import org.idoox.uddi.client.api.v2.response.TModelInfo;
import org.idoox.uddi.client.api.v2.response.TModelList;
import org.idoox.uddi.client.api.v2.response.BusinessDetail;
import org.idoox.uddi.client.api.v2.response.ServiceDetail;
import org.idoox.uddi.client.api.v2.response.TModelDetail;
import org.idoox.uddi.client.api.v2.response.BindingDetail;


public class UDDIQuery {
	
	/** UDDIv2 query stub */
	private UDDIApiInquiry inquiry;
	
	public UDDIQuery(String queryURL) {
		try {
			System.setProperty("wasp.restrictor.packages","-");
			// Get the UDDIv2 publishing stub for particular URL to invoke the save_business call.
			inquiry = UDDILookup.getInquiry(queryURL);
		}
		catch (Exception e) {
			e.printStackTrace();
		}
	}

	public BusinessKey findBusinessByName(String name) throws Exception{
		// FindBusiness instance - see org.idoox.uddi.client.request.inquiry.FindBusiness
		FindBusiness findBusiness = new FindBusiness();
		// set expected names and their language codes of the business that should be found
		findBusiness.addName(new Name(name));
		// you can specify maximum number of results
		findBusiness.setMaxRows(new MaxRows("1"));
		// API call find_business on UDDIInquiryPort - see org.idoox.uddi.client.api.v2.UDDIApiInquiry
		// BusinessList - structure that is returned - see org.idoox.uddi.client.v2.response.BusinessList
		BusinessList businessList = findBusiness(findBusiness);
		// get the business info
		BusinessInfo businessInfo = businessList.getBusinessInfos().getFirst();
		return businessInfo.getBusinessKey();
	}

	public BusinessKey findBusinessByIdentifier(KeyedReference identifier)  throws Exception{
		FindBusiness findBusiness = new FindBusiness();
		findBusiness.addIdentifier(identifier);
		// you can specify a maximum number of results
		findBusiness.setMaxRows(new MaxRows("1"));
		// API call find_business on UDDIInquiryPort - see org.idoox.uddi.client.api.v2.UDDIApiInquiry
		// BusinessList - structure that is returned - see org.idoox.uddi.client.v2.response.BusinessList
		BusinessList businessList = findBusiness(findBusiness);
		// get the business info
		BusinessInfo businessInfo = businessList.getBusinessInfos().getFirst();
		return businessInfo.getBusinessKey();
	}

	public BusinessKey findBusinessByCategory(KeyedReference category)  throws Exception{
		FindBusiness findBusiness = new FindBusiness();
		findBusiness.addCategory(category);
		// you can specify a maximum number of results
		findBusiness.setMaxRows(new MaxRows("1"));
		// API call find_business on UDDIInquiryPort - see org.idoox.uddi.client.api.v2.UDDIApiInquiry
		// BusinessList - structure that is returned - see org.idoox.uddi.client.v2.response.BusinessList
		BusinessList businessList = findBusiness(findBusiness);
		// get the business info
		BusinessInfo businessInfo = businessList.getBusinessInfos().getFirst();
		return businessInfo.getBusinessKey();
	}

	public BusinessKey findBusinessByDiscoveryURL(DiscoveryURL discoveryURL)  throws Exception{
		FindBusiness findBusiness = new FindBusiness();
		findBusiness.addDiscoveryURL(discoveryURL);
		// you can specify a maximum number of results
		findBusiness.setMaxRows(new MaxRows("1"));
		// API call find_business on UDDIInquiryPort - see org.idoox.uddi.client.api.v2.UDDIApiInquiry
		// BusinessList - structure that is returned - see org.idoox.uddi.client.v2.response.BusinessList
		BusinessList businessList = findBusiness(findBusiness);
		// get the business info		
		BusinessInfo businessInfo = businessList.getBusinessInfos().getFirst();
		return businessInfo.getBusinessKey();
	}

	public BusinessKey findBusinessByTModelKey(TModelKey key)  throws Exception{
		FindBusiness findBusiness = new FindBusiness();
		findBusiness.addTModel(key);
		// you can specify a maximum number of results
		findBusiness.setMaxRows(new MaxRows("1"));
		// API call find_business on UDDIInquiryPort - see org.idoox.uddi.client.api.v2.UDDIApiInquiry
		// BusinessList - structure that is returned - see org.idoox.uddi.client.v2.response.BusinessList
		BusinessList businessList = findBusiness(findBusiness);
		// get the business info
		BusinessInfo businessInfo = businessList.getBusinessInfos().getFirst();
		return businessInfo.getBusinessKey();
	}

	public BusinessKey findBusinessByNameAndCategory(String name, KeyedReference category)throws Exception{
		FindBusiness findBusiness = new FindBusiness();
		// set expected names and their language codes for the business that should be found
		findBusiness.addName(new Name(name));
		// set expected categories
		findBusiness.addCategory(category);
		// you can specify a maximum number of results
		findBusiness.setMaxRows(new MaxRows("1"));
		// API call find_business on UDDIInquiryPort - see org.idoox.uddi.client.api.v2.UDDIApiInquiry
		// BusinessList - structure that is returned - see org.idoox.uddi.client.v2.response.BusinessList
		BusinessList businessList = findBusiness(findBusiness);
		// get the business info
		BusinessInfo businessInfo = businessList.getBusinessInfos().getFirst();
		return businessInfo.getBusinessKey();
	}

	public BusinessList findBusiness(FindBusiness findBusiness) throws Exception {
		return inquiry.find_business(findBusiness);
	}
	
	public BusinessDetail getBusinessDetail(BusinessKey businessKey) throws Exception {
		if (businessKey == null){
				System.out.println("ERROR: Null businessKey");
				return null;
		}
		GetBusinessDetail getBusinessDetail = new GetBusinessDetail();
		getBusinessDetail.addBusinessKey(businessKey);
		// API call get_businessDetail on UDDIApiInquiry - see org.idoox.uddi.client.api.v2.UDDIApiInquiry
		return inquiry.get_businessDetail(getBusinessDetail);
	}
	
	public ServiceKey findServiceByName(BusinessKey businessKey, String name)throws Exception {
		// FindService instance - see org.idoox.uddi.client.request.inquiry.FindService
		FindService findService = new FindService();
		//key of the parent businessEntity
		findService.setBusinessKey(businessKey);
		// set expected names of the service that should be found
		findService.addName(new Name(name));
		// you can specify a maximum number of results
		findService.setMaxRows(new MaxRows("1"));
		// API call find_service on UDDIApiInquiry - see org.idoox.uddi.client.api.UDDIApiInquiry
		// ServiceList - structure that is returned - see org.idoox.uddi.client.v2.response.ServiceList
		ServiceList serviceList = findService(findService);
		// get the service info
		ServiceInfo serviceInfo = serviceList.getServiceInfos().getFirst();
		return serviceInfo.getServiceKey();
	}

	public ServiceKey findServiceByCategory(BusinessKey businessKey,KeyedReference category) throws Exception{
		FindService findService = new FindService();
		//key of the parent businessEntity
		findService.setBusinessKey(businessKey);
		findService.addCategory(category);
		// you can specify a maximum number of results
		findService.setMaxRows(new MaxRows("1"));
		// API call find_service on the UDDIInquiryPort - see org.idoox.uddi.client.api.v2.UDDIApiInquiry
		// ServiceList - structure that is returned - see org.idoox.uddi.client.v2.response.ServiceList
		ServiceList serviceList = findService(findService);
		// get the service info
		ServiceInfo serviceInfo = serviceList.getServiceInfos().getFirst();
		return serviceInfo.getServiceKey();
	}

	public ServiceKey findServiceByTModelKey(BusinessKey businessKey,TModelKey key) throws Exception{
		FindService findService = new FindService();
		//key of the parent businessEntity
		findService.setBusinessKey(businessKey);
		findService.addTModel(key);
		// you can specify a maximum number of results
		findService.setMaxRows(new MaxRows("1"));
		// API call find_service on UDDIInquiryPort - see org.idoox.uddi.client.api.v2.UDDIApiInquiry
		// ServiceList - structure that is returned - see org.idoox.uddi.client.v2.response.ServiceList
		ServiceList serviceList = findService(findService);
		// get the service info
		ServiceInfo serviceInfo = serviceList.getServiceInfos().getFirst();
		return serviceInfo.getServiceKey();
	}

	public ServiceKey findServiceByNameAndCategory(BusinessKey businessKey, String name, KeyedReference category) throws Exception{
		// FindService instance - see org.idoox.uddi.client.request.inquiry.FindService
		FindService findService = new FindService();
		//key of the parent businessEntity
		findService.setBusinessKey(businessKey);
		// set the expected names of the service that should be found
		findService.addName(new Name(name));
		//set expected category
		findService.addCategory(category);
		// you can specify a maximum number of results
		findService.setMaxRows(new MaxRows("1"));
		// API call find_service on UDDIApiInquiry - see org.idoox.uddi.client.api.UDDIApiInquiry
		// ServiceList - structure that is returned - see org.idoox.uddi.client.v2.response.ServiceList
		ServiceList serviceList = findService(findService);
		// get the service info
		ServiceInfo serviceInfo = serviceList.getServiceInfos().getFirst();
		return serviceInfo.getServiceKey();
	}

	public ServiceList findService(FindService findService) throws Exception {
		// API call find_service on UDDIApiInquiry - see org.idoox.uddi.client.api.v2.UDDIApiInquiry
		return inquiry.find_service(findService);
	}
	
	public ServiceDetail getServiceDetail(ServiceKey serviceKey) throws Exception {
		if (serviceKey == null){
				System.out.println("ERROR: Null serviceKey");
				return null;
		}
		GetServiceDetail getServiceDetail = new GetServiceDetail();
		getServiceDetail.addServiceKey(serviceKey);
		return inquiry.get_serviceDetail(getServiceDetail);
	}

	public TModelKey findTModelByName(String name)throws Exception {
		// FindTModel instance - see org.idoox.uddi.client.request.inquiry.FindTModel
		FindTModel findTModel = new FindTModel();
		// set expected name of the tModel for which you will search
		findTModel.setName(new Name(name));
		// you can specify maximum number of results
		findTModel.setMaxRows(new MaxRows("1"));
		// API call find_tModel on UDDIInquiryPort - see org.idoox.uddi.client.api.v2.UDDIApiInquiry
		// TModelList - structure that is returned - see org.idoox.uddi.client.v2.response.TModelList
		TModelList tModelList = findTModel(findTModel);
		TModelInfo tModelInfo = tModelList.getTModelInfos().getFirst();
		return tModelInfo.getTModelKey();
	}

	public TModelKey findTModelByCategory(KeyedReference category) throws Exception{
		FindTModel findTModel = new FindTModel();
		findTModel.addCategory(category);
		// you can specify a maximum number of results
		findTModel.setMaxRows(new MaxRows("1"));
		// API call find_tModel on UDDIInquiryPort - see org.idoox.uddi.client.api.v2.UDDIApiInquiry
		// TModelList - structure that is returned - see org.idoox.uddi.client.v2.response.TModelList
		TModelList tModelList = findTModel(findTModel);
		TModelInfo tModelInfo = tModelList.getTModelInfos().getFirst();
		return tModelInfo.getTModelKey();
	}

	public TModelKey findTModelByIdentifier(KeyedReference identifier) throws Exception{
		FindTModel findTModel = new FindTModel();
		findTModel.addIdentifier(identifier);
		// you can specify a maximum number of results
		findTModel.setMaxRows(new MaxRows("1"));
		// API call find_tModel on UDDIInquiryPort - see org.idoox.uddi.client.api.v2.UDDIApiInquiry
		// TModelList - structure that is returned - see org.idoox.uddi.client.v2.response.TModelList
		TModelList tModelList = findTModel(findTModel);
		TModelInfo tModelInfo = tModelList.getTModelInfos().getFirst();
		return tModelInfo.getTModelKey();
	}

	public TModelList findTModel(FindTModel findTModel) throws Exception {
		// API call find_tModel on UDDIApiInquiry - see org.idoox.uddi.client.api.v2.UDDIApiInquiry
		return inquiry.find_tModel(findTModel);
	}
	
	public TModelDetail getTModelDetail(TModelKey tModelKey) throws Exception {
		if (tModelKey == null){
				System.out.println("ERROR: Null tModelKey");
				return null;
		}
		GetTModelDetail getTModelDetail = new GetTModelDetail();
		getTModelDetail.addTModelKey(tModelKey);
		// API call get_tModelDetail on UDDIApiInquiry - see org.idoox.uddi.client.api.v2.UDDIApiInquiry
		return inquiry.get_tModelDetail(getTModelDetail);
	}
	
	public BindingKey findBindingByTModelKey(ServiceKey serviceKey,TModelKey tModelKey) throws Exception{
		FindBinding findBinding = new FindBinding();
		//key of the parent businessEntity
		findBinding.setServiceKey(serviceKey);
		findBinding.addTModelKey(tModelKey);
		// you can specify the maximum number of results
		findBinding.setMaxRows(new MaxRows("1"));
		// API call find_binding on UDDIInquiry - see org.idoox.uddi.client.api.v2.UDDIApiInquiry
		// BindingDetail - structure that is returned - see org.idoox.uddi.client.v2.response.BindingDetail
		BindingDetail bindingList = findBinding(findBinding);
		BindingTemplate bindingTemplate = bindingList.getBindingTemplates().getFirst();
		return bindingTemplate.getBindingKey();
	}

	public BindingDetail findBinding(FindBinding findBinding) throws Exception {
		// API call find_binding on UDDIApiInquiry - see org.idoox.uddi.client.api.v2.UDDIApiInquiry
		return inquiry.find_binding(findBinding);
	}

	public BindingDetail getBindingDetail(BindingKey bindingKey) throws  Exception {
		if (bindingKey == null){
				System.out.println("ERROR: Null bindingKey");
				return null;
		}
		GetBindingDetail getBindingDetail = new GetBindingDetail();
		getBindingDetail.addBindingKey(bindingKey);
		// API call get_bindingDetail on UDDIApiInquiry - see org.idoox.uddi.client.api.v2.UDDIApiInquiry
		return inquiry.get_bindingDetail(getBindingDetail);
	}

}