/*
 * Account.java
 *
 * Created on December 13, 2001, 9:17 AM
 */

package com.systinet.demos.bank;

/**
 * Account interface
 */
public interface Account
    extends java.rmi.Remote
{

    /**
     * Returns the account number
     * @return account number
     */
    public String getAccountNumber();

    /**
     * Sets the account number
     * @param accountNumber account number
     */
    public void setAccountNumber(String accountNumber);

    /**
     *  Returns the account balance
     * @return the actual balance of the account
     */
    public double getBalance();

    /**
     *  Sets the account balance
     * @param amount the actual balance of the account
     */
    public void setBalance(double amount);

    /**
     * Deposits to the account
     * @param amount amount of many to deposit
     */
    public void deposit(double amount);

    /**
     * Withdraw from the account
     * @param amount amount to withdraw
     * @throws UnsufficientFundsException thrown if account doesn't hava enough funds
     */
    public void withdraw(double amount)
        throws UnsufficientFundsException;

    /**
     * Close the account
     */
    public void close();

}
