/*
 * AccountImpl.java
 *
 * Created on December 13, 2001, 9:25 AM
 */

package com.systinet.demos.bank;

// imports of WASP security
import org.idoox.wasp.SecurityHelper;
import org.idoox.webservice.server.Initializable;
import org.idoox.webservice.server.WebServiceContext;

/**
 * Account implementation
 */
public class AccountImpl
    implements Account, Initializable
{
    private double balance = 0;
    private String number = "";
    private static final String SERVICE  = "bank";
    private static final String PASSWORD = "password";

    public AccountImpl()
    {
        this.number = ""+System.currentTimeMillis();
    }

    public void init(WebServiceContext serviceContext)
    {
    	/*
    	try{
	        boolean spkmAuthSuccess = SecurityHelper.authenticateServer(SERVICE, PASSWORD, "SPKM");
	        if(! spkmAuthSuccess){
	            serviceContext.log("Unable to authenticate SPKM");
	            throw new RuntimeException("Unable to authenticate SPKM");
	        }
      }
      catch(java.security.NoSuchProviderException e){
          throw new RuntimeException("Unable to authenticate SPKM, provider not found");
      }
      */
  	}

    public void destroy()
    {
        // do nothing here
    }

    /**
     * Deposits to the account
     * @param amount amount of many to deposit
     */
    synchronized public void deposit(double amount)
    {
        this.balance += amount;
    }

    /**
     * Withdraw from the account
     * @param amount amount to withdraw
     * @throws UnsufficientFundsException thrown if account doesn't hava enough funds
     */
    synchronized public void withdraw(double amount)
        throws UnsufficientFundsException
    {
        if(amount < this.balance) {
            this.balance = this.balance - amount;
        }
        else {
            throw new UnsufficientFundsException("The withdrawal of " + amount +
                                                 " was requested but the balance is only " +
                                                 this.balance+" .");
        }
    }

    /**
     * Returns the account balance
     * @return the actual balance of the account
     */
    synchronized public double getBalance()
    {
        return this.balance;
    }

    /**
     * Sets the account balance
     * @param amount the actual balance of the account
     */
    synchronized public void setBalance(double amount)
    {
        this.balance = amount;
    }

    /**
     * Returns the account number
     * @return account number
     */
    public String getAccountNumber()
    {
        return this.number;
    }

    /**
     * Sets the account number
     * @param accountNumber account number
     */
    public void setAccountNumber(String accountNumber)
    {
        this.number = accountNumber;
    }

    /**
     * Close the account
     */
    public void close()
    {
        org.idoox.webservice.server.WebServiceContext context =
            org.idoox.webservice.server.WebServiceContext.getInstance();
        org.idoox.webservice.server.LifeCycleService lc = context.getLifeCycleService();
        lc.disposeServiceInstance(this);
    }

}