/*
 * This is a WASP client.
 * BankClient.java
 * Created on December 13, 2001, 10:41 AM
 */
package com.systinet.demos.bank.client;

import com.systinet.demos.bank.Account;

import org.idoox.webservice.client.WebServiceLookup;
import org.idoox.wasp.Context;
import org.idoox.wasp.SecurityHelper;

/**
 * Bank client application
 */
public class BankClient
    extends Object
{
	
		private static final String CLIENT  = "john";
    private static final String PASSWORD = "password";
    
    /**
     * Runs the demo on the client-side
     * @param args the command line arguments
     */
    public static void main (String args[])
        throws Exception
    {
        System.out.println("Authenticating user "+CLIENT);
        // init the lookup
        WebServiceLookup lookup = (WebServiceLookup)
            Context.getInstance(Context.WEBSERVICE_LOOKUP);

        // obtain and set the crededentials
				if(!SecurityHelper.authenticateClient(CLIENT, PASSWORD, "HttpBasic")){
        	throw new RuntimeException("cannot authenticate by HttpBasic mechanism");
        }
        // get the proxy to the Web Service from the lookup
        Account account = (Account)
            lookup.lookup("http://localhost:6060/Bank", Account.class);
        // now, call the methods on your Web Service interface
        System.out.println("Account #" + account.getAccountNumber() + " created.");
        System.out.println("Putting $10 000 on account #" +
                           account.getAccountNumber() + " .");
        account.deposit(10000);
        System.out.println("Getting $7 000 from account #" +
                           account.getAccountNumber() + " .");
        account.withdraw(7000);
        System.out.println("Account #" + account.getAccountNumber() + " balance is "
                           + account.getBalance());
        account.close();
    }
}
