package com.systinet.demos.interref.client;


import com.systinet.demos.interref.Order;
import com.systinet.demos.interref.LineItem;

import javax.xml.namespace.QName;
import org.idoox.wasp.Context;
import org.idoox.webservice.client.WebServiceLookup;

public final class OrderClient {

    public static void main( String[] args ) throws Exception {
        
      // lookup service
      WebServiceLookup lookup = (WebServiceLookup)Context.getInstance(Context.WEBSERVICE_LOOKUP);
      
      Order order = (Order)lookup.lookup("http://localhost:6060/Interref/", 
                new QName("http://systinet.com/wsdl/com/systinet/demos/interref/", "JavaService"),
                "OrderImpl", Order.class);
      
      String id1 = order.addItem("THNKPDT23", 2).getID();
      String id2 = order.addItem("THNKPDT22", 2).getID();
      
      System.out.println("ID1 "+id1);
      System.out.println("ID2 "+id2);
      
      LineItem item = order.getItem(id1);
      
      System.out.println("Line ITEM");
      System.out.println("---------");
      System.out.println("ID:         "+item.getID());
      System.out.println("Product ID: "+item.getProductID());
      System.out.println("Count:      "+item.getCount());
     
      item = order.getItem(id2);
      
      System.out.println("Line ITEM");
      System.out.println("---------");
      System.out.println("ID:         "+item.getID());
      System.out.println("Product ID: "+item.getProductID());
      System.out.println("Count:      "+item.getCount());

      
    }

}