package com.systinet.demos.mapping.client;

import org.idoox.wasp.Context;
import org.idoox.webservice.client.WebServiceLookup;

public final class OrderClient {

    public static void main( String[] args ) throws Exception {
        
      WebServiceLookup lookup = (WebServiceLookup)Context.getInstance(Context.WEBSERVICE_LOOKUP);
      OrderService service = (OrderService)lookup.lookup("http://localhost:6060/Mapping/",OrderService.class);

      OrderRequest order = new OrderRequest();
      order.symbol = "SUNW";
      order.type = com.systinet.demos.mapping.OrderRequest.ORDER_TYPE_BUY;
      order.limitPrice = 10;
      order.volume = 100000;
      String result = service.processOrder(order);
      
      System.out.println(result);
      
      order = new OrderRequest();
      order.symbol = "BEAS";
      order.type = com.systinet.demos.mapping.OrderRequest.ORDER_TYPE_BUY;
      order.limitPrice = 13;
      order.volume = 213000;
      result = service.processOrder(order);
      
      System.out.println(result);
      
      java.util.HashMap orders = service.getOrders();
      
      java.util.Iterator iter = orders.keySet().iterator();
      
      while(iter.hasNext()) {
      	Long id = (Long)iter.next();
      	com.systinet.demos.mapping.OrderRequest req = (com.systinet.demos.mapping.OrderRequest)orders.get(id);
      	System.out.println("\n----------------------------");
        System.out.println("\nID:             "+id);
        System.out.println("\nTYPE:           "+((req.getType()==com.systinet.demos.mapping.OrderRequest.ORDER_TYPE_SELL)?("SELL"):("BUY")));
        System.out.println("\nSYMBOL:         "+req.getSymbol());
        System.out.println("\nLIMIT PRICE:    "+req.getLimitPrice());
        System.out.println("\nVOLUME:         "+req.getVolume());
      }
      
    }

}