/*
 * JMusicFinder.java
 *
 * Created on March 14, 2002, 12:18 PM
 */

package demo.freedb;

import javax.swing.tree.DefaultTreeModel;

/**
 *
 * @author  Zdenek Svoboda
 */
public class JMusicFinderDirect extends javax.swing.JFrame {
	
	/** Creates new form JMusicFinder */
	public JMusicFinderDirect() {
		initComponents();
		
		java.awt.GridBagConstraints gridBagConstraints;
		
		chooser = new JCategoryChooser();
		chooser.setPreferredSize(new java.awt.Dimension(130, 21));
    chooser.setMinimumSize(new java.awt.Dimension(126, 21));
    chooser.setMaximumSize(new java.awt.Dimension(32767, 21));
    gridBagConstraints = new java.awt.GridBagConstraints();
    gridBagConstraints.gridx = 1;
    gridBagConstraints.gridy = 2;
    gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
    gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
    gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
    gridBagConstraints.weightx = 1.0;
    getContentPane().add(chooser, gridBagConstraints);
		
		this.jTreeResult.setModel(new DefaultTreeModel(new CDRecordTreeNode(null)));
	}
	
	/** This method is called from within the constructor to
	 * initialize the form.
	 * WARNING: Do NOT modify this code. The content of this method is
	 * always regenerated by the Form Editor.
	 */
  private void initComponents() {//GEN-BEGIN:initComponents
    java.awt.GridBagConstraints gridBagConstraints;

    jLabel1 = new javax.swing.JLabel();
    jTextKeywords = new javax.swing.JTextField();
    jLabel3 = new javax.swing.JLabel();
    jScrollPane1 = new javax.swing.JScrollPane();
    jTreeResult = new javax.swing.JTree();
    jButtonSearch = new javax.swing.JButton();
    jLabel11 = new javax.swing.JLabel();
    jTextQueryURL = new javax.swing.JTextField();

    getContentPane().setLayout(new java.awt.GridBagLayout());

    addWindowListener(new java.awt.event.WindowAdapter() {
      public void windowClosing(java.awt.event.WindowEvent evt) {
        exitForm(evt);
      }
    });

    jLabel1.setText("Keywords:");
    gridBagConstraints = new java.awt.GridBagConstraints();
    gridBagConstraints.gridx = 0;
    gridBagConstraints.gridy = 1;
    gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
    gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
    getContentPane().add(jLabel1, gridBagConstraints);

    jTextKeywords.setPreferredSize(new java.awt.Dimension(200, 21));
    gridBagConstraints = new java.awt.GridBagConstraints();
    gridBagConstraints.gridx = 1;
    gridBagConstraints.gridy = 1;
    gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
    gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
    gridBagConstraints.weightx = 1.0;
    gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
    getContentPane().add(jTextKeywords, gridBagConstraints);

    jLabel3.setText("Field:");
    gridBagConstraints = new java.awt.GridBagConstraints();
    gridBagConstraints.gridx = 0;
    gridBagConstraints.gridy = 2;
    gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
    gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
    getContentPane().add(jLabel3, gridBagConstraints);

    jScrollPane1.setMinimumSize(new java.awt.Dimension(200, 200));
    jScrollPane1.setViewportView(jTreeResult);

    gridBagConstraints = new java.awt.GridBagConstraints();
    gridBagConstraints.gridx = 0;
    gridBagConstraints.gridy = 6;
    gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
    gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
    gridBagConstraints.weightx = 1.0;
    gridBagConstraints.weighty = 1.0;
    getContentPane().add(jScrollPane1, gridBagConstraints);

    jButtonSearch.setText("Search");
    jButtonSearch.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        jButtonSearchActionPerformed(evt);
      }
    });

    gridBagConstraints = new java.awt.GridBagConstraints();
    gridBagConstraints.gridx = 1;
    gridBagConstraints.gridy = 3;
    gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
    gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
    getContentPane().add(jButtonSearch, gridBagConstraints);

    jLabel11.setText("WSDL URL:");
    gridBagConstraints = new java.awt.GridBagConstraints();
    gridBagConstraints.gridx = 0;
    gridBagConstraints.gridy = 0;
    gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
    gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
    getContentPane().add(jLabel11, gridBagConstraints);

    jTextQueryURL.setEditable(false);
    jTextQueryURL.setText("http://soap.systinet.net/ws/FreeDbService/");
    jTextQueryURL.setPreferredSize(new java.awt.Dimension(200, 21));
    gridBagConstraints = new java.awt.GridBagConstraints();
    gridBagConstraints.gridx = 1;
    gridBagConstraints.gridy = 0;
    gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
    gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
    gridBagConstraints.weightx = 1.0;
    gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
    getContentPane().add(jTextQueryURL, gridBagConstraints);

    pack();
  }//GEN-END:initComponents

	private void jButtonSearchActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonSearchActionPerformed
		try {
			String keywords = this.jTextKeywords.getText();
			String fields = this.chooser.getFields();
			
			MusicServiceFactory factory = new HardCodedMusicServiceFactory();
			java.util.HashMap params = new java.util.HashMap();
			params.put(MusicServiceFactory.PARAM_DIRECT_URL, this.jTextQueryURL.getText()); 
			MusicService service = factory.createMusicService(params);
			
			CDQuery query = new CDQuery();
			query.setWords(keywords);
			query.setField(fields);
			query.setAllCats(true);
			query.setAllFields(false);
			
			CDRecord[] records = service.getCDRecords(query);
			DefaultTreeModel model = new DefaultTreeModel(new CDRecordTreeNode(records));
			this.jTreeResult.setModel(model);
			
		}
		catch (Exception e) {
			e.printStackTrace();
		}
	}//GEN-LAST:event_jButtonSearchActionPerformed
	
	/** Exit the Application */
	private void exitForm(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_exitForm
		System.exit(0);
	}//GEN-LAST:event_exitForm
	
	/**
	 * @param args the command line arguments
	 */
	public static void main(String args[]) {
		JMusicFinderDirect form = new JMusicFinderDirect();
		form.setSize(500,400);
		form.show();
	}
	
	
  // Variables declaration - do not modify//GEN-BEGIN:variables
  private javax.swing.JTree jTreeResult;
  private javax.swing.JTextField jTextKeywords;
  private javax.swing.JTextField jTextQueryURL;
  private javax.swing.JLabel jLabel3;
  private javax.swing.JButton jButtonSearch;
  private javax.swing.JScrollPane jScrollPane1;
  private javax.swing.JLabel jLabel1;
  private javax.swing.JLabel jLabel11;
  // End of variables declaration//GEN-END:variables
	private JCategoryChooser chooser;
}
