package demo.freedb;

// imports of WASP classes
import org.idoox.webservice.client.WebServiceLookup;
import org.idoox.wasp.Context;

import org.idoox.uddi.client.structure.v2.business.BusinessKey;
import org.idoox.uddi.client.structure.v2.service.ServiceKey;
import org.idoox.uddi.client.structure.v2.tmodel.TModelKey;

import org.idoox.uddi.client.structure.v2.tmodel.TModel;
import org.idoox.uddi.client.structure.v2.service.BusinessService;
import org.idoox.uddi.client.structure.v2.binding.BindingTemplate;
import org.idoox.uddi.client.structure.v2.binding.AccessPoint;
import org.idoox.uddi.client.structure.v2.binding.TModelInstanceDetails;
import org.idoox.uddi.client.structure.v2.binding.TModelInstanceInfo;
import org.idoox.uddi.client.structure.v2.binding.InstanceDetails;

import org.idoox.uddi.client.structure.v2.base.OverviewDoc;
import org.idoox.uddi.client.structure.v2.base.OverviewURL;

import org.idoox.uddi.client.api.v2.response.ServiceDetail;
import org.idoox.uddi.client.api.v2.response.TModelDetail;



import demo.uddi.UDDIQuery;

/**
 * Music service factory that uses hard coded values
 * @author  Zdenek Svoboda
 */
public class UDDIMusicServiceFactory implements MusicServiceFactory {
	
	/**
	 * Creates the new music srvice instance
	 * @param url service URL
	 * @return Music service instance
	 * @throws Exception if any error occurs
	 */
	public MusicService createMusicService(java.util.Map params) throws Exception {
		// get the lookup object
		WebServiceLookup lookup = (WebServiceLookup) Context.getInstance(Context.WEBSERVICE_LOOKUP);
		UDDIQuery query = new UDDIQuery((String)params.get(MusicServiceFactory.PARAM_UDDI_URL));
		
		// find business
		BusinessKey businessKey = query.findBusinessByName((String)params.get(MusicServiceFactory.PARAM_BUSINESS_NAME));
		// find service
		ServiceKey serviceKey = query.findServiceByName(businessKey, "MusicService");
		ServiceDetail serviceDetail = query.getServiceDetail(serviceKey);
		BusinessService service = serviceDetail.getBusinessServices().getFirst();
		// get binding template
		BindingTemplate bindingTemplate = service.getBindingTemplates().getFirst();
		// get access point URL
		AccessPoint accessPoint = bindingTemplate.getAccessPoint();
		String url = accessPoint.getValue();
		// get tModel instance info and the WSDLURL (service type description)
		TModelInstanceDetails tModelInstanceDetails = bindingTemplate.getTModelInstanceDetails();
		TModelInstanceInfo tmodelInstanceInfo = tModelInstanceDetails.getFirst();
		TModelKey tModelKey = tmodelInstanceInfo.getTModelKey();
		TModelDetail tModelDetail = query.getTModelDetail(tModelKey);
		TModel tModel = tModelDetail.getTModels().getFirst();
		OverviewDoc od = tModel.getOverviewDoc();
		OverviewURL ou = od.getOverviewURL();
		String wsdlURL = ou.getValue();
		// get the proxy to the Web Service from the lookup
		return (MusicService)lookup.lookup(wsdlURL, MusicService.class, url);
	}
	
}
