package examples.ejb20.basic.beanManagedDependentValueObjects;

import java.rmi.RemoteException;
import javax.ejb.EJBObject;
import java.util.Iterator;
import examples.ejb20.basic.beanManagedDependentValueObjects.*;

public interface Resume extends EJBObject {

/**
 * Adds a job to our resume
 */
public void addJobEntry(JobDependentValue aJob) throws DuplicateDependentObjectException, RemoteException;

/**
 * Deletes job entry from this resume
 */
public void deleteJobEntry(JobDependentValue aJob) throws NoSuchDependentObjectException, RemoteException;

/**
 * Lazy loads our Address Dependent Object
 * @return this resume's address
 */
public AddressDependentValue getAddress()throws RemoteException;

/**
 * Returns all job entries contained in this resume to the client
 */
public Object[] getJobEntries() throws RemoteException;

/**
 * Insert the method's description here.
 */
public void setAddress(AddressDependentValue newAddress) throws RemoteException;

/**
 * Updates an existing job entry with new one.
 * This is the only way to "modify" our dependent object, since
 * job entries don't have an "identity", we can't simply "set" a new
 * job entry, we need to have a copy of the old one to know which one
 * we are talking about.
 */
public void updateJobEntry(JobDependentValue oldJob, JobDependentValue newJob) throws NoSuchDependentObjectException, RemoteException;
}
