package examples.ejb20.basic.beanManagedDependentValueObjects;

import java.util.*;

/**
 * Job Dependent Value models the concept of a Job Entry dependent object,
 * used in a one-to-many relationship from a resume.
 *
 * @author: Floyd Marinescu, Senior Architect, The Middleware Company.
 * The Middleware Company is an Enterprise Java Training company. Visit our
 * website at: www.middleware-company.com.
 * Copyright 2001 The Middleware Company.
 */

public class JobDependentValue implements java.io.Serializable {
	protected String company;
	protected String position;
	protected Date beginDate;
	protected Date endDate;
	protected String jobDescription;

public JobDependentValue() {
	super();
}

public JobDependentValue( String company, String position,Date beginDate, Date endDate, String jobDescription )
{
	this.company        = company;
	this.position       = position;
	this.beginDate      = beginDate;
	this.endDate        = endDate;
	this.jobDescription = jobDescription;
	
}

public java.util.Date getBeginDate() {
	return beginDate;
}

public java.lang.String getCompany() {
	return company;
}

public java.util.Date getEndDate() {
	return endDate;
}

public java.lang.String getJobDescription() {
	return jobDescription;
}

public java.lang.String getPosition() {
	return position;
}

void setBeginDate(java.util.Date newBeginDate) {
	beginDate = newBeginDate;
}

void setCompany(java.lang.String newCompany) {
	company = newCompany;
}

void setEndDate(java.util.Date newEndDate) {
	endDate = newEndDate;
}

void setJobDescription(java.lang.String newJobDescription) {
	jobDescription = newJobDescription;
}

void setPosition(java.lang.String newPosition) {
	position = newPosition;
}
}
