package examples.ejb20.basic.beanManagedDependentValueObjects;

import java.sql.*;
import javax.naming.*;
import java.util.*;

/**
 * Simply a class that creates the necessary tables to run this example using
 * the cloudscape database that ships with Weblogic. 
 * 
 * Included here to show the tables required for this example.
 *
 * @author: Floyd Marinescu, Senior Architect, The Middleware Company.
 * The Middleware Company is an Enterprise Java Training company. Visit our
 * website at: www.middleware-company.com.
 * Copyright 2001 The Middleware Company.
 */

public class TableCreator {
 
public static void main(String args[])
{
	System.out.println("Table Creator starting");
	java.sql.Connection con = null;
	try
	{
		
	  // ============== Make connection to database ==================
	  // Obtain a Datasource connection from the WebLogic JNDI tree.
	  Context ctx = null;
	 
	  // Put connection properties in to a hashtable. 
	  Hashtable ht = new Hashtable();
	  ht.put(Context.INITIAL_CONTEXT_FACTORY,
			 "weblogic.jndi.WLInitialContextFactory");
	  ht.put(Context.PROVIDER_URL,
			 "t3://localhost:7001");

	  // Get a context for the JNDI look up
	  ctx = new InitialContext(ht);
	  javax.sql.DataSource ds
		  = (javax.sql.DataSource) ctx.lookup ("examples-dataSource-demoPool");
	  con = ds.getConnection();
	  System.out.println("Making connection...\n");

	  
		Statement stmt = con.createStatement();

		//delete previous table and create new one ******************************
  		try
  		{
			stmt.execute( "drop table resumes");
		}
  		catch(Exception e) {}

		
		stmt.execute(   "create table resumes ("+
	                                      "id			varchar (10) ,"+
	                                      "firstName 	varchar (50),"+
	                                      "lastName		varchar (100) )"  );

	    System.out.println("Created resumes table");
	    

		//delete previous table and create new one ******************************
		try
		{
 			stmt.execute( "drop table addresses");
		}
		catch(Exception e) {}
	

		stmt.execute(   "create table addresses ("+
	                                      "resumeid			varchar (50),"+
	                                    "address1 			varchar (50)," +
	                                    "address2 			varchar (50)," +
	                                    "city 				varchar (50)," +
	                                    "state 				varchar (50)," +
	                                    "country 			varchar (50)," +	                                     
	                                    "postalcode 		varchar (50)," +
	                                    "phonenumber  		longint)  ");
			
		System.out.println("Created addresses table");

		//delete previous table and create new one ******************************
		try
		{
 			stmt.execute( "drop table jobentries");
		}
		catch(Exception e) {}
	

		stmt.execute(   "create table jobentries ("+
	                                      "resumeid			varchar(50),"+
	                                    "company 			varchar (50)," +
	                                    "jobposition 			varchar (50)," +
	                                    "description		varchar (50)," +
	                                    "begindate 				varchar (50)," +
	                                    "enddate 			varchar (50))");
			
		System.out.println("Created jobentries table");

		System.out.println("Tables for this example have been created, now you can run the example");
	}
	catch(SQLException e)
	{
		e.printStackTrace();
		e.getNextException().getMessage();
	}	
	catch(Exception e) 
	{
		e.printStackTrace();
		e.getMessage();
	}
	finally
	{
		try {con.close();}catch(Exception e){}
	}
}
}
