package com.joshlong.userregistrationexample;

import com.joshlong.userregistrationexample.model.User;

/**
 * central interface by which manipulation of Users occurs
 *
 * @author Josh Long
 */
public interface UserManagmentService {

    User getUserForHash(String hash);

    String getHashForUser(long userId);

    User getUserById(long userId);

    void createUserRegistrationProcess(long userId);

    User createUser(String email, String password, String firstName, String lastName);

    User createUser(String email, String password);

    void updateUser(long userId, String email, String password, String firstName, String lastName);

    User login(String email, String password);
}

