package com.joshlong.userregistrationexample.impl;

import com.joshlong.userregistrationexample.UserManagmentService;
import com.joshlong.userregistrationexample.model.User;
import com.joshlong.userregistrationexample.workflow.WorkflowService;
import org.apache.commons.lang.StringUtils;
import org.jbpm.graph.exe.ProcessInstance;
import org.springframework.context.ApplicationContextAware;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class UserManagmentServiceImpl extends BaseService implements UserManagmentService, ApplicationContextAware {

    private WorkflowService workflowService;

    public WorkflowService getWorkflowService() {
        return workflowService;
    }

    public void setWorkflowService(WorkflowService workflowService) {
        this.workflowService = workflowService;
    }

    /**
     * Returns a user for a hashcode given hashcode. This is a nonsensical version.
     * Storing an MD5 hash and matching against that is far safer.
     *
     * @param hash
     * @return
     */
    public User getUserForHash(String hash) {
        long userId = Long.parseLong(hash);
        User user = getUserById(userId);
        return user;
    }

    /**
     * returns a hash for the user ID. This is a nonsensical version.
     * A secure hash like MD5 is more useful.
     *
     * @param userId
     * @return
     */
    public String getHashForUser(long userId) {
        String userIdString = Long.toString(userId);
        return userIdString;
    }

    public User getUserById(long userId) {
        List<User> users = getHibernateTemplate().findByNamedParam("SELECT u FROM User u WHERE u.id = :userId", "userId", userId);
        if (users.size() > 0) {
            return users.get(0);
        }
        return null;
    }

    public void createUserRegistrationProcess(long userId) {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("userId", userId);
        ProcessInstance processInstance = workflowService.createProcessInstance("user-registration", params);
        workflowService.startProcessInstance(processInstance.getId());
        
    }

    public User createUser(String email, String password, String firstName, String lastName) {
        User user = new User();
        Date now = new Date();
        user.setCreated(now);
        user.setLastUpdated(now);
        user.setEmail(email);
        user.setPassword(password);
        user.setFirstName(firstName);
        user.setLastName(lastName);
        getHibernateTemplate().saveOrUpdate(user);

        if (StringUtils.isEmpty(email) || StringUtils.isEmpty(password) || StringUtils.isEmpty(firstName) || StringUtils.isEmpty(lastName))
            throw new RuntimeException("Invalid data! This will be rolled back!");

        return user;
    }

    public User createUser(String email, String password) {
        return createUser(email, password, null, null);
    }

    public void updateUser(long userId, String email, String password, String firstName, String lastName) {
        User user = getUserById(userId);
        user.setEmail(email);
        user.setPassword(password);
        user.setFirstName(firstName);
        user.setLastName(lastName);
        getHibernateTemplate().saveOrUpdate(user);
    }

    public User login(String email, String password) {
        List<User> users = getHibernateTemplate().findByNamedParam(
                "SELECT u FROM User u WHERE u.email = :email and u.password = :pw", new String[]{"email", "pw"}, new Object[]{email, password});
        if (users.size() > 0) {
            return users.get(0);
        }
        return null;
    }

}
