package com.joshlong.userregistrationexample.model;

@javax.persistence.Entity
@javax.persistence.Table(name = "SITE_USER")
public class User implements java.io.Serializable, Comparable<User> {

    private static final long serialVersionUID = 7007332536324935539L;

    private java.util.Date created;
    private java.util.Date lastUpdated;
    private java.lang.String firstName;
    private java.lang.String email, password;
    private java.lang.String lastName;
    private java.lang.Long id;

    public User() {
    }

    // -------- Attribute Accessors ----------

    /**
     * Get the created property.
     *
     * @return java.util.Date The value of created
     */
    @javax.persistence.Column(name = "CREATED", nullable = false, insertable = true, updatable = true)
    @javax.persistence.Temporal(javax.persistence.TemporalType.TIMESTAMP)
    public java.util.Date getCreated() {
        return created;
    }

    /**
     * Set the created property.
     *
     * @param value the new value
     */
    public void setCreated(java.util.Date value) {
        this.created = value;
    }

    /**
     * Get the lastUpdated property.
     *
     * @return java.util.Date The value of lastUpdated
     */
    @javax.persistence.Column(name = "LAST_UPDATED", nullable = false, insertable = true, updatable = true)
    @javax.persistence.Temporal(javax.persistence.TemporalType.TIMESTAMP)
    public java.util.Date getLastUpdated() {
        return lastUpdated;
    }

    /**
     * Set the lastUpdated property.
     *
     * @param value the new value
     */
    public void setLastUpdated(java.util.Date value) {
        this.lastUpdated = value;
    }

    /**
     * Get the email property.
     *
     * @return java.lang.String The value of name
     */
    @javax.persistence.Column(name = "PASSWORD", nullable = false, insertable = true, updatable = true)
    public java.lang.String getPassword() {
        return password;
    }

    /**
     * Set the email property.
     *
     * @param value the new value
     */
    public void setPassword(java.lang.String value) {
        this.password = value;
    }

    /**
     * Get the email property.
     *
     * @return java.lang.String The value of name
     */
    @javax.persistence.Column(name = "EMAIL", nullable = false, insertable = true, updatable = true)
    public java.lang.String getEmail() {
        return email;
    }

    /**
     * Set the email property.
     *
     * @param value the new value
     */
    public void setEmail(java.lang.String value) {
        this.email = value;
    }

    /**
     * Get the name property.
     *
     * @return java.lang.String The value of name
     */
    @javax.persistence.Column(name = "FIRST_NAME", nullable = false, insertable = true, updatable = true)
    public java.lang.String getFirstName() {
        return firstName;
    }

    /**
     * Set the name property.
     *
     * @param value the new value
     */
    public void setFirstName(java.lang.String value) {
        this.firstName = value;
    }

    /**
     * Get the hostname property.
     *
     * @return java.lang.String The value of hostname
     */
    @javax.persistence.Column(name = "LAST_NAME", insertable = true, updatable = true)
    public java.lang.String getLastName() {
        return lastName;
    }

    /**
     * Set the hostname property.
     *
     * @param value the new value
     */
    public void setLastName(java.lang.String value) {
        this.lastName = value;
    }

    /**
     * Get the id property.
     *
     * @return java.lang.Long The value of id
     */
    @javax.persistence.Id
    @javax.persistence.GeneratedValue(strategy = javax.persistence.GenerationType.AUTO)
    @javax.persistence.Column(name = "ID", nullable = false, insertable = true, updatable = true)
    public java.lang.Long getId() {
        return id;
    }

    /**
     * Set the id property.
     *
     * @param value the new value
     */
    public void setId(java.lang.Long value) {
        this.id = value;
    }

    // -------- Common Methods -----------

    /**
     * Indicates if the argument is of the same type and all values are equal.
     *
     * @param object The target object to compare with
     * @return boolean True if both objects a 'equal'
     */
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof User)) {
            return false;
        }
        final User that = (User) object;
        if (this.getId() == null || that.getId() == null || !this.getId().equals(that.getId())) {
            return false;
        }
        return true;
    }

    /**
     * Returns a hash code value for the object
     *
     * @return int The hash code value
     */
    public int hashCode() {
        int hashCode = 0;
        hashCode = 29 * hashCode + (getId() == null ? 0 : getId().hashCode());

        return hashCode;
    }

    /**
     * @see java.lang.Comparable#compareTo(T)
     */
    public int compareTo(User o) {
        int cmp = 0;
        if (this.getId() != null) {
            cmp = this.getId().compareTo(o.getId());
        } else {
            if (this.getCreated() != null) {
                cmp = (cmp != 0 ? cmp : this.getCreated().compareTo(o.getCreated()));
            }
            if (this.getLastUpdated() != null) {
                cmp = (cmp != 0 ? cmp : this.getLastUpdated().compareTo(o.getLastUpdated()));
            }
            if (this.getFirstName() != null) {
                cmp = (cmp != 0 ? cmp : this.getFirstName().compareTo(o.getFirstName()));
            }
            if (this.getLastName() != null) {
                cmp = (cmp != 0 ? cmp : this.getLastName().compareTo(o.getLastName()));
            }
            if (this.getPassword() != null) {
                cmp = (cmp != 0 ? cmp : this.getPassword().compareTo(o.getPassword()));
            }
            if (this.getEmail() != null) {
                cmp = (cmp != 0 ? cmp : this.getEmail().compareTo(o.getEmail()));
            }
        }
        return cmp;
    }
}
