package com.joshlong.userregistrationexample;

import com.joshlong.userregistrationexample.model.User;
import junit.framework.TestCase;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class TestServices extends TestCase {

    public void testCreatingAUser() throws Throwable {

        ApplicationContext context = new ClassPathXmlApplicationContext("service-context.xml");

        UserManagmentService ums = (UserManagmentService) context.getBean("userManagmentService");

        // are hashes redeemable for a user?
        User user = ums.createUser("josh@joshlong.com", "password", "Josh", "Long");
        String hashForUser = ums.getHashForUser(user.getId());

        assertTrue("a User ID and a user hash should be exchangeable!",
                ums.getUserForHash(hashForUser).getId().equals(user.getId()));

        // does invalid data get across?
        try {
            user = ums.createUser(null, null, "First1", "Last1");
            fail("You shouldnt be allowed to get this far!");
        } catch (Throwable t) {
        }

    }

}
