package com.joshlong.userregistrationexample.view;

import com.joshlong.userregistrationexample.UserManagmentService;
import com.joshlong.userregistrationexample.model.User;
import org.apache.log4j.Logger;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.SimpleFormController;

public class SignUpFormPageController extends SimpleFormController {

    private static Logger log = Logger.getLogger(SignUpFormPageController.class);

    public SignUpFormPageController() {
        setCommandClass(User.class);
        setCommandName("user");
    }

    protected ModelAndView onSubmit(Object o) throws Exception {
        User user = (User) o;

        log.debug("Creating user " + user.getEmail() + ":" + user.getPassword() + ":" + user.getFirstName() + ":" + user.getLastName());

        User realUser = userManagmentService.createUser(user.getEmail(), user.getPassword(), user.getFirstName(), user.getLastName());
        userManagmentService.createUserRegistrationProcess(realUser.getId());

        log.debug(String.format("Created a new user; am submitting user having email '%s' and ID %s for user-registration", realUser.getEmail(), realUser.getId().toString()));

        return new ModelAndView(getSuccessView(), "user", realUser);

    }

    private UserManagmentService userManagmentService;

    public void setUserManagmentService(UserManagmentService userManagmentService) {
        this.userManagmentService = userManagmentService;
    }

}
