package com.joshlong.userregistrationexample.view;

import com.joshlong.userregistrationexample.UserManagmentService;
import com.joshlong.userregistrationexample.model.User;
import com.joshlong.userregistrationexample.workflow.WorkflowService;
import org.apache.log4j.Logger;
import org.springframework.validation.BindException;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.AbstractCommandController;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.HashMap;
import java.util.Map;

class SignupConfirmationControllerParameters {
    private String userIdHash;

    public String getUserIdHash() {
        return userIdHash;
    }

    public void setUserIdHash(String userIdHash) {
        this.userIdHash = userIdHash;
    }
}

public class SignupConfirmationController extends AbstractCommandController {

    public SignupConfirmationController() {
        setCommandClass(SignupConfirmationControllerParameters.class);
    }

    private static Logger log = Logger.getLogger(SignupConfirmationController.class);

    private UserManagmentService userManagmentService;

    public void setUserManagmentService(UserManagmentService userManagmentService) {
        this.userManagmentService = userManagmentService;
    }

    private WorkflowService workflowService;

    public void setWorkflowService(WorkflowService workflowService) {
        this.workflowService = workflowService;
    }

    protected ModelAndView handle(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Object o, BindException e) throws Exception {
        SignupConfirmationControllerParameters params = (SignupConfirmationControllerParameters) o;

        User user = userManagmentService.getUserForHash(params.getUserIdHash());

        Map<String, Object> paramstpl = new HashMap<String, Object>();
        paramstpl.put("userIdHash", params.getUserIdHash());
        paramstpl.put("user", user);

        Map<String, Object> predicates = new HashMap<String, Object>();
        predicates.put("userId", user.getId());

        Long confirmRegistration = workflowService.lockNextTaskInstanceByActorAndCriteria("signup-confirmation-actor", predicates);

        if (null != confirmRegistration) {
            log.debug("Fetched a taskInstance for signup-confirmation-actor");
            workflowService.completeTaskInstance(confirmRegistration);
        }

        return new ModelAndView("signupConfirmation", paramstpl);
    }

}
