package com.joshlong.userregistrationexample.view.validators;

import com.joshlong.userregistrationexample.model.User;
import org.springframework.validation.Errors;
import org.springframework.validation.ValidationUtils;
import org.springframework.validation.Validator;

public class UserValidator implements Validator {
    public boolean supports(Class aClass) {
        return aClass.isAssignableFrom(User.class) || aClass.equals(User.class);
    }

    public void validate(Object o, Errors errors) {

        User user = (User) o;

        ValidationUtils.rejectIfEmptyOrWhitespace(errors, "firstName", "required.firstName", "First Name is required");
        ValidationUtils.rejectIfEmptyOrWhitespace(errors, "lastName", "required.lastName", "Last Name is required");
        ValidationUtils.rejectIfEmptyOrWhitespace(errors, "email", "required.email", "E-Mail is required");

        ValidationUtils.rejectIfEmptyOrWhitespace(errors, "password", "required.password", "Password is required");

    }
}
