/*
 * Decompiled with CFR 0.152.
 */
package examples;

import examples.LineItem;
import examples.Order;
import examples.OrderHome;
import examples.OrderLineItem;
import examples.OrderLineItemHome;
import examples.Product;
import examples.ProductHome;
import examples.ProductItem;
import java.rmi.RemoteException;
import java.util.Iterator;
import java.util.Vector;
import javax.ejb.EJBException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.naming.InitialContext;
import javax.rmi.PortableRemoteObject;

public class CartBean
implements SessionBean {
    private static final String productHomeName = "java:comp/env/ejb/ProductHome";
    private String owner;
    private Vector contents;
    private SessionContext ctx;
    private double subTotal;
    private double taxes;
    static /* synthetic */ Class class$examples$ProductHome;
    static /* synthetic */ Class class$examples$OrderLineItemHome;
    static /* synthetic */ Class class$examples$OrderHome;

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String string) {
        this.owner = string;
    }

    public void add(LineItem lineItem) {
        Iterator iterator = this.contents.iterator();
        try {
            while (iterator.hasNext()) {
                LineItem lineItem2 = (LineItem)iterator.next();
                ProductItem productItem = lineItem2.getProductItem();
                if (productItem == null || !productItem.getProductID().equals(lineItem.getProductItem().getProductID())) continue;
                lineItem2.setQuantity(lineItem2.getQuantity() + lineItem.getQuantity());
                return;
            }
            this.contents.add(lineItem);
        }
        catch (Exception exception) {
            throw new EJBException(exception);
        }
    }

    public void modify(String string, int n) throws Exception {
        System.out.println("CartBean.modify()");
        Iterator iterator = this.contents.iterator();
        while (iterator.hasNext()) {
            LineItem lineItem = (LineItem)iterator.next();
            ProductItem productItem = lineItem.getProductItem();
            if (productItem == null || !productItem.getProductID().equals(string)) continue;
            lineItem.setQuantity(n);
            if (n == 0) {
                iterator.remove();
            }
            return;
        }
        throw new Exception("CartBean.modify() error: Could not find product " + string);
    }

    private Product getProduct(String string) {
        try {
            InitialContext initialContext = new InitialContext();
            ProductHome productHome = (ProductHome)PortableRemoteObject.narrow((Object)initialContext.lookup(productHomeName), (Class)(class$examples$ProductHome == null ? (class$examples$ProductHome = CartBean.class$("examples.ProductHome")) : class$examples$ProductHome));
            Product product = productHome.findByPrimaryKey(string);
            return product;
        }
        catch (Exception exception) {
            throw new EJBException(exception);
        }
    }

    public Vector getAll() {
        return this.contents;
    }

    public double getSubtotal() throws RemoteException {
        return this.subTotal;
    }

    public void setSubtotal(double d) throws RemoteException {
        this.subTotal = d;
    }

    public double getTaxes() throws RemoteException {
        return this.taxes;
    }

    public void setTaxes(double d) throws RemoteException {
        this.taxes = d;
    }

    public double getTotalPrice() throws RemoteException {
        return this.subTotal + this.taxes;
    }

    public void clear() {
        this.contents.clear();
    }

    public String purchase() {
        System.out.println("CartBean.purchase()");
        try {
            OrderHome orderHome = this.getOrderHome();
            String string = this.makeUniqueID();
            Order order = orderHome.create(string, this.owner, "unverified", this.subTotal, this.taxes);
            Vector vector = this.addOrderLineItems(order);
            order.setLineItems(vector);
            this.sendMessage(string);
            return string;
        }
        catch (Exception exception) {
            throw new EJBException(exception);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void sendMessage(String string) throws Exception {
        Connection connection = null;
        MessageProducer messageProducer = null;
        Session session = null;
        try {
            InitialContext initialContext = new InitialContext();
            ConnectionFactory connectionFactory = (ConnectionFactory)initialContext.lookup("jms/MyQcf");
            Destination destination = (Destination)initialContext.lookup("jms/OrderQueue");
            connection = connectionFactory.createConnection();
            session = connection.createSession(false, 1);
            messageProducer = session.createProducer(destination);
            connection.start();
            TextMessage textMessage = session.createTextMessage();
            textMessage.setText(string);
            messageProducer.send((Message)textMessage);
            Object var10_10 = null;
            if (connection == null) return;
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            if (connection == null) throw throwable;
            try {
                messageProducer.close();
                connection.close();
                session.close();
                throw throwable;
            }
            catch (JMSException jMSException) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (JMSException jMSException) {}
        messageProducer.close();
        connection.close();
        session.close();
        return;
    }

    private Vector addOrderLineItems(Order order) {
        try {
            InitialContext initialContext = new InitialContext();
            OrderLineItemHome orderLineItemHome = (OrderLineItemHome)PortableRemoteObject.narrow((Object)initialContext.lookup("java:comp/env/ejb/OrderLineItemHome"), (Class)(class$examples$OrderLineItemHome == null ? (class$examples$OrderLineItemHome = CartBean.class$("examples.OrderLineItemHome")) : class$examples$OrderLineItemHome));
            ProductHome productHome = (ProductHome)PortableRemoteObject.narrow((Object)initialContext.lookup(productHomeName), (Class)(class$examples$ProductHome == null ? (class$examples$ProductHome = CartBean.class$("examples.ProductHome")) : class$examples$ProductHome));
            Vector<OrderLineItem> vector = new Vector<OrderLineItem>();
            for (int i = 0; i < this.contents.size(); ++i) {
                LineItem lineItem = (LineItem)this.contents.elementAt(i);
                Product product = productHome.findByPrimaryKey(lineItem.getProductItem().getProductID());
                String string = this.makeUniqueID();
                OrderLineItem orderLineItem = orderLineItemHome.create(string, order, product, lineItem.getQuantity(), lineItem.getDiscount());
                vector.add(orderLineItem);
            }
            return vector;
        }
        catch (Exception exception) {
            throw new EJBException(exception);
        }
    }

    private String makeUniqueID() {
        return new Long(System.currentTimeMillis()).toString();
    }

    private OrderHome getOrderHome() {
        try {
            InitialContext initialContext = new InitialContext();
            OrderHome orderHome = (OrderHome)PortableRemoteObject.narrow((Object)initialContext.lookup("java:comp/env/ejb/OrderHome"), (Class)(class$examples$OrderHome == null ? (class$examples$OrderHome = CartBean.class$("examples.OrderHome")) : class$examples$OrderHome));
            return orderHome;
        }
        catch (Exception exception) {
            throw new EJBException(exception);
        }
    }

    public void setSessionContext(SessionContext sessionContext) {
        System.out.println("setSessionContext()");
        this.ctx = sessionContext;
    }

    public void ejbCreate(String string) {
        System.out.println("ejbCreate(" + string + ")");
        this.owner = string;
        this.contents = new Vector();
    }

    public void ejbActivate() {
        System.out.println("ejbActivate()");
    }

    public void ejbPassivate() {
        System.out.println("ejbPassivate()");
    }

    public void ejbRemove() {
        System.out.println("ejbRemove()");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

