/*
 * Decompiled with CFR 0.152.
 */
package examples;

import examples.Cart;
import examples.Catalog;
import examples.CatalogHome;
import examples.LineItem;
import examples.ProductItem;
import java.io.IOException;
import java.util.Vector;
import javax.naming.InitialContext;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class CatalogServlet
extends HttpServlet {
    private CatalogHome catalogHome = null;

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        try {
            InitialContext initialContext = new InitialContext();
            this.catalogHome = (CatalogHome)initialContext.lookup("ejb/CatalogHome");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void service(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        Vector vector = null;
        try {
            HttpSession httpSession = httpServletRequest.getSession(false);
            if (httpSession == null) {
                httpServletResponse.sendRedirect(httpServletResponse.encodeRedirectURL("/jasmine/login"));
                return;
            }
            Object object = httpSession.getAttribute("cart");
            if (object == null) {
                httpServletResponse.sendRedirect(httpServletResponse.encodeRedirectURL("/jasmine/login"));
                return;
            }
            Cart cart = (Cart)object;
            String string = httpServletRequest.getParameter("Buy");
            vector = (Vector)httpSession.getAttribute("products");
            String string2 = httpServletRequest.getParameter("productId");
            if (string != null) {
                try {
                    ProductItem productItem = this.getProductItem(vector, string);
                    cart.add(new LineItem(productItem, 1, 0.0));
                    httpServletRequest.setAttribute("ProductPurchased", (Object)productItem.getName());
                    this.getServletContext().getRequestDispatcher("/catalog.jsp").forward((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
                    return;
                }
                catch (Exception exception) {
                    throw new ServletException(exception.toString());
                }
            }
            if (string2 != null) {
                httpServletRequest.setAttribute("productItem", (Object)this.getProductItem(vector, string2));
                this.getServletContext().getRequestDispatcher("/productInfo.jsp").forward((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
                return;
            }
            if (vector == null) {
                Catalog catalog = this.catalogHome.create();
                vector = catalog.getProductItemList();
                httpSession.setAttribute("products", (Object)vector);
            }
            this.getServletContext().getRequestDispatcher("/catalog.jsp").forward((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    private ProductItem getProductItem(Vector vector, String string) {
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            ProductItem productItem = (ProductItem)vector.elementAt(i);
            if (!productItem.getProductID().equals(string)) continue;
            return productItem;
        }
        return null;
    }

    public String getServletInfo() {
        return "The Catalog servlet adds products to the user's cart and prints the catalog.";
    }
}

