/*
 * Decompiled with CFR 0.152.
 */
package examples;

import examples.Customer;
import examples.CustomerHome;
import examples.OrderLineItem;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Iterator;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.EntityBean;
import javax.ejb.EntityContext;
import javax.ejb.RemoveException;
import javax.naming.InitialContext;
import javax.rmi.PortableRemoteObject;

public abstract class OrderBean
implements EntityBean {
    private static final String customerHomeName = "java:comp/env/ejb/CustomerHome";
    protected EntityContext ctx;
    static /* synthetic */ Class class$examples$CustomerHome;

    public abstract String getOrderID();

    public abstract void setOrderID(String var1);

    public abstract Collection getLineItems();

    public abstract void setLineItems(Collection var1);

    public abstract Customer getCustomer();

    public abstract void setCustomer(Customer var1);

    public abstract Timestamp getOrderDate();

    public abstract void setOrderDate(Timestamp var1);

    public abstract String getStatus();

    public abstract void setStatus(String var1);

    public abstract double getSubTotal();

    public abstract void setSubTotal(double var1);

    public abstract double getTaxes();

    public abstract void setTaxes(double var1);

    public double getTotalPrice() {
        double d = 0.0;
        Iterator iterator = this.getLineItems().iterator();
        while (iterator.hasNext()) {
            OrderLineItem orderLineItem = (OrderLineItem)iterator.next();
            d += orderLineItem.getProduct().getBasePrice();
        }
        return d;
    }

    public void setEntityContext(EntityContext entityContext) {
        System.out.println("Order.setEntityContext called");
        this.ctx = entityContext;
    }

    public void unsetEntityContext() {
        System.out.println("Order.unsetEntityContext called");
        this.ctx = null;
    }

    public void ejbActivate() {
        System.out.println("Order.ejbActivate() called.");
    }

    public void ejbPassivate() {
        System.out.println("Order.ejbPassivate () called.");
    }

    public void ejbStore() {
        System.out.println("Order.ejbStore() called.");
    }

    public void ejbLoad() {
        System.out.println("Order.ejbLoad() called.");
    }

    public String ejbCreate(String string, Customer customer, Collection collection) throws CreateException {
        System.out.println("Order.ejbCreate(" + string + ") called");
        this.setOrderID(string);
        this.setOrderDate(new Timestamp(System.currentTimeMillis()));
        this.setStatus("submitted");
        return null;
    }

    public String ejbCreate(String string, Customer customer, String string2, double d, double d2) throws CreateException {
        System.out.println("Order.ejbCreate(" + string + ") called");
        this.setOrderID(string);
        this.setOrderDate(new Timestamp(System.currentTimeMillis()));
        this.setStatus(string2);
        this.setSubTotal(d);
        this.setTaxes(d2);
        return null;
    }

    public String ejbCreate(String string, String string2, Collection collection) throws CreateException {
        System.out.println("Order.ejbCreate(" + string + ") called");
        this.setOrderID(string);
        this.setOrderDate(new Timestamp(System.currentTimeMillis()));
        this.setStatus("submitted");
        return null;
    }

    public String ejbCreate(String string, String string2, String string3, double d, double d2) throws CreateException {
        this.setOrderID(string);
        this.setOrderDate(new Timestamp(System.currentTimeMillis()));
        this.setStatus(string3);
        this.setSubTotal(d);
        this.setTaxes(d2);
        return null;
    }

    public void ejbPostCreate(String string, Customer customer, Collection collection) throws CreateException {
        System.out.println("Order.ejbPostCreate() 1  called");
        this.setCustomer(customer);
    }

    public void ejbPostCreate(String string, String string2, Collection collection) throws CreateException {
        System.out.println("Order.ejbPostCreate() called");
        try {
            InitialContext initialContext = new InitialContext();
            CustomerHome customerHome = (CustomerHome)PortableRemoteObject.narrow((Object)initialContext.lookup(customerHomeName), (Class)(class$examples$CustomerHome == null ? (class$examples$CustomerHome = OrderBean.class$("examples.CustomerHome")) : class$examples$CustomerHome));
            Customer customer = customerHome.findByPrimaryKey(string2);
            this.setCustomer(customer);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new EJBException(exception);
        }
    }

    public void ejbPostCreate(String string, Customer customer, String string2, double d, double d2) throws CreateException {
        System.out.println("Order.ejbPostCreate() 1  called");
        this.setCustomer(customer);
    }

    public void ejbPostCreate(String string, String string2, String string3, double d, double d2) throws CreateException {
        System.out.println("Order.ejbPostCreate() called");
        try {
            InitialContext initialContext = new InitialContext();
            CustomerHome customerHome = (CustomerHome)PortableRemoteObject.narrow((Object)initialContext.lookup(customerHomeName), (Class)(class$examples$CustomerHome == null ? (class$examples$CustomerHome = OrderBean.class$("examples.CustomerHome")) : class$examples$CustomerHome));
            Customer customer = customerHome.findByPrimaryKey(string2);
            this.setCustomer(customer);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new EJBException(exception);
        }
    }

    public void ejbRemove() throws RemoveException {
        System.out.println("Order.ejbRemove() called.");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

