/*
 * Decompiled with CFR 0.152.
 */
package examples;

import examples.Cart;
import examples.LineItem;
import examples.PricerException;
import examples.User;
import examples.UserManager;
import examples.UserManagerHome;
import java.rmi.RemoteException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.StringTokenizer;
import javax.ejb.EJBException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.rmi.PortableRemoteObject;

public class PricerBean
implements SessionBean {
    public static final String ENV_DISCOUNT = "java:comp/env/PricerProps/DISCOUNT_";
    public static final String ENV_TAX_RATE = "java:comp/env/PricerProps/TAX_RATE";
    public static final String ENV_BULK_DISCOUNT_RATE = "java:comp/env/PricerProps/BULK_DISCOUNT_RATE";
    private static final int BULK = 5;
    private SessionContext ctx;
    static /* synthetic */ Class class$examples$UserManagerHome;

    public void price(Cart cart) throws PricerException, RemoteException {
        this.priceSubtotal(cart);
        this.priceTaxes(cart);
    }

    public double getDiscount(int n, double d, String string) {
        double d2 = this.getPersonalDiscountRate(string);
        if (n >= 5) {
            d2 += this.getBulkDiscountRate();
        }
        return d * (d2 / 100.0);
    }

    public double getBulkDiscountRate() {
        double d = 0.0;
        try {
            InitialContext initialContext = new InitialContext();
            String string = (String)initialContext.lookup(ENV_BULK_DISCOUNT_RATE);
            d = Double.valueOf(string);
            System.out.println("Bulk Discount Rate:" + d);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return d;
    }

    public double getPersonalDiscountRate(String string) {
        User user = this.getUser(string);
        String string2 = user.getCustomerID();
        boolean bl = true;
        int n = 0;
        try {
            InitialContext initialContext = new InitialContext();
            while (bl) {
                String string3 = (String)initialContext.lookup(ENV_DISCOUNT + n++);
                System.out.println("Discount: " + string3);
                StringTokenizer stringTokenizer = new StringTokenizer(string3, "=", false);
                String string4 = stringTokenizer.nextToken();
                double d = Double.valueOf(stringTokenizer.nextToken());
                if (!string4.equals(string2)) continue;
                System.out.println("Pricer.priceSubtotal(): " + string2 + " gets a " + d + "% discount.");
                return d;
            }
        }
        catch (NameNotFoundException nameNotFoundException) {
            bl = false;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println("Pricer.priceSubtotal(): " + string2 + " doesn't get a discount.");
        }
        return 0.0;
    }

    private void priceSubtotal(Cart cart) throws PricerException, RemoteException {
        System.out.println("PricerBean.priceSubtotal() called");
        String string = cart.getOwner();
        Enumeration enumeration = Collections.enumeration(cart.getAll());
        double d = 0.0;
        try {
            while (enumeration.hasMoreElements()) {
                LineItem lineItem = (LineItem)enumeration.nextElement();
                double d2 = this.getDiscount(lineItem.quantity, lineItem.getBasePrice(), string);
                lineItem.setDiscount(d2);
                d += lineItem.getBasePrice() - d2;
            }
            cart.setSubtotal(d);
        }
        catch (Exception exception) {
            throw new PricerException(exception.toString());
        }
    }

    private User getUser(String string) {
        try {
            InitialContext initialContext = new InitialContext();
            UserManagerHome userManagerHome = (UserManagerHome)PortableRemoteObject.narrow((Object)initialContext.lookup("ejb/UserManagerHome"), (Class)(class$examples$UserManagerHome == null ? (class$examples$UserManagerHome = PricerBean.class$("examples.UserManagerHome")) : class$examples$UserManagerHome));
            UserManager userManager = userManagerHome.create();
            User user = userManager.getUser(string);
            return user;
        }
        catch (Exception exception) {
            throw new EJBException(exception);
        }
    }

    private void priceTaxes(Cart cart) throws PricerException, RemoteException {
        System.out.println("PricerBean.priceTaxes() called");
        try {
            double d = this.getTaxRate();
            double d2 = cart.getSubtotal();
            cart.setTaxes(d / 100.0 * d2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new PricerException(exception.toString());
        }
    }

    public double getTaxRate() {
        double d = 0.0;
        try {
            InitialContext initialContext = new InitialContext();
            String string = (String)initialContext.lookup(ENV_TAX_RATE);
            d = Double.valueOf(string);
            System.out.println("Tax Rate:" + d);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return d;
    }

    public void ejbCreate() throws RemoteException {
        System.out.println("Pricer.ejbCreate() called.");
    }

    public void ejbRemove() {
        System.out.println("ejbRemove() called.");
    }

    public void ejbActivate() {
        System.out.println("ejbActivate() called.");
    }

    public void ejbPassivate() {
        System.out.println("ejbPassivate() called.");
    }

    public void setSessionContext(SessionContext sessionContext) {
        System.out.println("setSessionContext() called");
        this.ctx = sessionContext;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

