/*
 * Decompiled with CFR 0.152.
 */
package examples;

import examples.CartHome;
import examples.UserManagerHome;
import java.io.IOException;
import javax.naming.InitialContext;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class LoginServlet
extends HttpServlet {
    private UserManagerHome userManagerHome;
    private CartHome cartHome;

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        try {
            InitialContext initialContext = new InitialContext();
            this.userManagerHome = (UserManagerHome)initialContext.lookup("ejb/UserManagerHome");
            this.cartHome = (CartHome)initialContext.lookup("ejb/CartHome");
        }
        catch (Exception exception) {
            this.log(exception);
            throw new ServletException(exception.toString());
        }
    }

    public void service(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        Object object;
        HttpSession httpSession = httpServletRequest.getSession(true);
        String string = httpServletRequest.getParameter("Login");
        String string2 = httpServletRequest.getParameter("Password");
        boolean bl = false;
        if (string == null || string2 == null) {
            this.writeForm(httpServletRequest, httpServletResponse, false);
            return;
        }
        try {
            object = this.userManagerHome.create();
            bl = object.validateUser(string, string2);
        }
        catch (Exception exception) {
            this.writeForm(httpServletRequest, httpServletResponse, true);
            exception.printStackTrace();
            return;
        }
        if (bl) {
            try {
                object = this.cartHome.create(string);
                httpSession.setAttribute("cart", object);
                RequestDispatcher requestDispatcher = this.getServletContext().getRequestDispatcher("/wsf.jsp");
                requestDispatcher.forward((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
                return;
            }
            catch (Exception exception) {
                this.log(exception);
                throw new ServletException(exception.toString());
            }
        }
        this.writeForm(httpServletRequest, httpServletResponse, true);
    }

    private void writeForm(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, boolean bl) throws ServletException, IOException {
        httpServletRequest.setAttribute("loginFailed", (Object)new Boolean(bl));
        RequestDispatcher requestDispatcher = this.getServletContext().getRequestDispatcher("/login.jsp");
        requestDispatcher.forward((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
    }

    private void log(Exception exception) {
        exception.printStackTrace();
    }

    public String getServletInfo() {
        return "The Login servlet verifies a user.";
    }
}

