/*
 * Decompiled with CFR 0.152.
 */
package examples;

import examples.Cart;
import examples.Pricer;
import examples.PricerHome;
import java.io.IOException;
import java.text.NumberFormat;
import java.util.Enumeration;
import java.util.Vector;
import javax.naming.InitialContext;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class ShowQuoteServlet
extends HttpServlet {
    private Pricer pricer;

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        try {
            InitialContext initialContext = new InitialContext();
            PricerHome pricerHome = (PricerHome)initialContext.lookup("ejb/PricerHome");
            this.pricer = pricerHome.create();
        }
        catch (Exception exception) {
            this.log(exception);
            throw new ServletException(exception.toString());
        }
    }

    public void service(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        Object object;
        HttpSession httpSession = httpServletRequest.getSession(false);
        if (httpSession == null) {
            httpServletResponse.sendRedirect(httpServletResponse.encodeRedirectURL("/jasmine/login"));
            return;
        }
        Object object2 = httpSession.getAttribute("cart");
        if (object2 == null) {
            httpServletResponse.sendRedirect(httpServletResponse.encodeRedirectURL("/jasmine/login"));
            return;
        }
        Cart cart = (Cart)object2;
        if (httpServletRequest.getParameter("Order") != null) {
            String string = cart.purchase();
            httpServletRequest.setAttribute("orderID", (Object)string);
            cart.clear();
            this.getServletContext().getRequestDispatcher("/receipt.jsp").forward((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
            return;
        }
        Enumeration enumeration = httpServletRequest.getParameterNames();
        while (enumeration.hasMoreElements()) {
            object = (String)enumeration.nextElement();
            String string = httpServletRequest.getParameter((String)object);
            if (((String)object).equals("Update")) continue;
            if (((String)object).equals("Clear")) {
                cart.clear();
                this.getServletContext().getRequestDispatcher("/clearQuote.jsp").forward((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
                return;
            }
            try {
                int n = Integer.parseInt(string);
                cart.modify((String)object, n);
            }
            catch (NumberFormatException numberFormatException) {
                throw new ServletException("Bad parameter to servlet: " + (String)object + ", " + string);
            }
            catch (Exception exception) {
                throw new ServletException(exception.toString());
            }
        }
        try {
            this.pricer.price(cart);
        }
        catch (Exception exception) {
            this.log(exception);
            throw new ServletException(exception.toString());
        }
        object = cart.getAll();
        if (((Vector)object).size() > 0) {
            httpServletRequest.setAttribute("lineItems", object);
            httpServletRequest.setAttribute("subTotal", (Object)new Double(cart.getSubtotal()));
            httpServletRequest.setAttribute("taxes", (Object)new Double(cart.getTaxes()));
            httpServletRequest.setAttribute("total", (Object)new Double(cart.getTotalPrice()));
            this.getServletContext().getRequestDispatcher("/showQuote.jsp").forward((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
            return;
        }
        this.getServletContext().getRequestDispatcher("/emptyQuote.jsp").forward((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
    }

    private String format(double d) {
        NumberFormat numberFormat = NumberFormat.getCurrencyInstance();
        return numberFormat.format(d);
    }

    private void log(Exception exception) {
        exception.printStackTrace();
    }

    public String getServletInfo() {
        return "The ShowQuote servlet returns information aboutthe products that the user is in the process of ordering.";
    }
}

