/*
 * Decompiled with CFR 0.152.
 */
package examples.security;

import com.sun.enterprise.security.auth.login.PasswordCredential;
import java.io.IOException;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;

public class PasswordLoginModule
implements LoginModule {
    private Subject subject;
    private CallbackHandler callbackHandler;
    private String username;
    private char[] password;

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map map, Map map2) {
        this.subject = subject;
        this.callbackHandler = callbackHandler;
    }

    public boolean login() throws LoginException {
        if (this.callbackHandler == null) {
            throw new LoginException("Error: No CallbackHandler available to collect authentication information");
        }
        Callback[] callbackArray = new Callback[]{new NameCallback("username: "), new PasswordCallback("password: ", false)};
        try {
            this.callbackHandler.handle(callbackArray);
            this.username = ((NameCallback)callbackArray[0]).getName();
            if (this.username == null) {
                throw new LoginException("No user specified");
            }
            char[] cArray = ((PasswordCallback)callbackArray[1]).getPassword();
            if (cArray == null) {
                cArray = new char[]{};
            }
            this.password = new char[cArray.length];
            System.arraycopy(cArray, 0, this.password, 0, cArray.length);
            ((PasswordCallback)callbackArray[1]).clearPassword();
        }
        catch (IOException iOException) {
            throw new LoginException(iOException.toString());
        }
        catch (UnsupportedCallbackException unsupportedCallbackException) {
            throw new LoginException("Error: No Callback available to collect authentication data :" + unsupportedCallbackException.getCallback().toString());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return true;
    }

    public boolean commit() throws LoginException {
        PasswordCredential passwordCredential = new PasswordCredential(this.username, new String(this.password), "fileRealm");
        this.subject.getPrivateCredentials().add(passwordCredential);
        this.username = null;
        this.password = null;
        return true;
    }

    public boolean abort() throws LoginException {
        return true;
    }

    public boolean logout() throws LoginException {
        this.username = null;
        this.password = null;
        return true;
    }
}

