/*
 * Decompiled with CFR 0.152.
 */
package examples.out_loan_ra;

import examples.out_loan_ra.ConnectionImpl;
import examples.out_loan_ra.ManagedConnectionMetaDataImpl;
import java.io.PrintWriter;
import javax.resource.NotSupportedException;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionEvent;
import javax.resource.spi.ConnectionEventListener;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.LocalTransaction;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.ManagedConnectionMetaData;
import javax.security.auth.Subject;
import javax.transaction.xa.XAResource;

public class ManagedConnectionImpl
implements ManagedConnection {
    private ConnectionEventListener connEventListener;
    private ManagedConnectionFactory manConnFactory;
    private boolean isDestroyed;
    private PrintWriter manConnLogWriter;

    ManagedConnectionImpl(ManagedConnectionFactory managedConnectionFactory) {
        System.out.println("ManagedConnectionImpl(ManagedConnectionFactory) called");
        this.manConnFactory = managedConnectionFactory;
    }

    public Object getConnection(Subject subject, ConnectionRequestInfo connectionRequestInfo) throws ResourceException {
        System.out.println("ManagedConnectionImpl.getConnection(Subject, ConnectionRequestInfo) called");
        ConnectionImpl connectionImpl = new ConnectionImpl(this);
        return connectionImpl;
    }

    public void destroy() throws ResourceException {
        System.out.println("ManagedConnectionImpl.destroy() called");
        this.isDestroyed = true;
        this.cleanup();
    }

    public void cleanup() throws ResourceException {
        System.out.println("ManagedConnectionImpl.cleanup() called");
    }

    public void associateConnection(Object object) throws ResourceException {
        throw new NotSupportedException("ManagedConnectionImpl.associateConnection() not supported.");
    }

    public void addConnectionEventListener(ConnectionEventListener connectionEventListener) {
        System.out.println("ManagedConnectionImpl.addConnectionEventListener(ConnectionEventListener) called");
        this.connEventListener = connectionEventListener;
    }

    public void removeConnectionEventListener(ConnectionEventListener connectionEventListener) {
    }

    public XAResource getXAResource() throws ResourceException {
        throw new NotSupportedException("Global transactions are not supported");
    }

    public LocalTransaction getLocalTransaction() throws ResourceException {
        throw new NotSupportedException("Local transactions are not supported");
    }

    public ManagedConnectionMetaData getMetaData() throws ResourceException {
        if (this.isDestroyed) {
            throw new ResourceException("Managed connection has already been closed.");
        }
        return new ManagedConnectionMetaDataImpl(this);
    }

    public void setLogWriter(PrintWriter printWriter) {
        this.manConnLogWriter = printWriter;
    }

    public PrintWriter getLogWriter() {
        return this.manConnLogWriter;
    }

    void sendEvent(int n, Exception exception, Object object) {
        System.out.println("ManagedConnectionImpl.sendEvent(int, e, connHandle) called");
        ConnectionEvent connectionEvent = null;
        connectionEvent = exception == null ? new ConnectionEvent((ManagedConnection)this, n) : new ConnectionEvent((ManagedConnection)this, n, exception);
        connectionEvent.setConnectionHandle(object);
        switch (connectionEvent.getId()) {
            case 1: {
                this.connEventListener.connectionClosed(connectionEvent);
                break;
            }
            case 2: {
                this.connEventListener.localTransactionStarted(connectionEvent);
                break;
            }
            case 3: {
                this.connEventListener.localTransactionCommitted(connectionEvent);
                break;
            }
            case 4: {
                this.connEventListener.localTransactionRolledback(connectionEvent);
                break;
            }
            case 5: {
                this.connEventListener.connectionErrorOccurred(connectionEvent);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported event: " + connectionEvent.getId());
            }
        }
    }

    ManagedConnectionFactory getManagedConnectionFactory() {
        return this.manConnFactory;
    }
}

