package examples.bmp;

import javax.ejb.*;
import java.rmi.RemoteException;

/**
 * This is the remote interface for AccountBean.
 *
 * This interface is what clients operate on when they interact with
 * beans. The container will implement this interface; the
 * implemented object is called the EJB object, which delegates
 * invocations to the actual bean.
 */
public interface Account 
    extends EJBObject 
{
    /**
     * Deposits amt into account.
     */
    public void deposit(double amt) 
        throws AccountException, RemoteException;
        
    /**
     * Withdraws amt from bank account.
     * @throw AccountException thrown if amt > available balance
     */
    public void withdraw(double amt) 
        throws AccountException, RemoteException;

    // Getter/setter methods on Entity Bean fields

    public double getBalance() throws RemoteException;

    public String getOwnerName() throws RemoteException;
    public void setOwnerName(String name) throws RemoteException;

    public String getAccountID() throws RemoteException;
    public void setAccountID(String id) throws RemoteException;
}
