package examples.bmp;

import javax.ejb.*;
import java.util.Collection;
import java.rmi.RemoteException;

/**
 * This is the  home interface for Account.  This
 * interface is implemented by the EJB container's tools - the
 * implemented object is called the home object, which
 * is a factory for EJB objects.
 */
public interface AccountHome 
    extends EJBHome 
{
   /**
    * We define a single create() method is in this home interface,
    * which corresponds to the ejbCreate() method in AccountBean.
    * This method creates the local EJB object.
    *
    * Notice that the local home interface returns a local interface,
    * whereas the bean returns a PK.
    *
    * Notice we don't throw RemoteExceptions because we are local.
    *
    * @param accountID The number of the account (unique)
    * @param ownerName The name of the person who owns the account
    * @return The newly created local object.
    */
   Account create(String accountID, String ownerName) 
       throws CreateException, RemoteException;

   /**
    * Finds an Account by its primary Key (Account ID)
    */
   public Account findByPrimaryKey(AccountPK key) 
       throws FinderException, RemoteException;

   /**
    * Finds all Accounts under an owner's name
    */
   public Collection findByOwnerName(String name) 
       throws FinderException, RemoteException;

   /**
    * This home business method is independent of any particular
    * account.  It returns the total of all accounts in the bank.
    */
   public double getTotalBankValue() 
       throws AccountException, RemoteException;

}
