package examples.bmp;

import javax.ejb.*;

/**
 * This is the local interface for AccountBean.
 *
 * This interface is what clients operate on when they interact with
 * beans. The container will implement this interface; the
 * implemented object is called the local object, which delegates
 * invocations to the actual bean.
 */
public interface AccountLocal 
    extends EJBLocalObject 
{
    /**
     * Deposits amt into account.
     */
    public void deposit(double amt) throws AccountException;
        
    /**
     * Withdraws amt from bank account.
     * @throw AccountException thrown in amt < available balance
     */
    public void withdraw(double amt) throws AccountException;

    // Getter/setter methods on Entity Bean fields

    public double getBalance();

    public String getOwnerName();
    public void setOwnerName(String name);

    public String getAccountID();
    public void setAccountID(String id);
}
