package examples.bmp;

import javax.ejb.*;
import java.util.Collection;

/**
 * This is the local home interface for Account.  This
 * interface is implemented by the EJB container's tools - the
 * implemented object is called the local home object, which
 * is a factory for local EJB objects.
 */
public interface AccountLocalHome 
    extends EJBLocalHome {

   /**
    * We define a single create() method is in this home interface,
    * which corresponds to the ejbCreate() method in AccountBean.
    * This method creates the local EJB object.
    *
    * Notice that the local home interface returns a
    * local interface, whereas the bean returns a PK.
    *
    * Notice we don't throw RemoteExceptions because we are
    * local not remote.
    *
    * @param accountID The number of the account (unique)
    * @param ownerName The name of the person who owns the account
    * @return The newly created local object.
    */
   AccountLocal create(String accountID, String ownerName) 
       throws CreateException;

   /**
    * Finds an Account by its primary Key (Account ID)
    */
   public AccountLocal findByPrimaryKey(AccountPK key) 
       throws FinderException;

   /**
    * Finds all Accounts under an owner's name
    */
   public Collection findByOwnerName(String name) 
       throws FinderException;

   /**
    * This home business method is independent of any particular
    * account instance.  It returns the total of all the bank
    * accounts in the bank.
    */
   public double getTotalBankValue() 
       throws AccountException;

}
