package examples;

import java.util.*;
import org.omg.CosNaming.*;

// if your ORB does not support CosTransactions, comment
// out this line:
import org.omg.CosTransactions.*;

public class CORBAClient 
{   
    public static void main(String[] args) 
        throws Exception 
    {
        /*
         * Initialize the ORB.
         */
        org.omg.CORBA.ORB orb = org.omg.CORBA.ORB.init(args, null);

        /*
         * Get a reference to a naming context
         */
        NamingContext context = NamingContextHelper.narrow
            (orb.resolve_initial_references("NameService"));

        /*
         * Look up the home object using COS Naming
         */
        NameComponent[] names = { new NameComponent("HelloHome", "") };
        HelloHome helloHome = HelloHomeHelper.narrow
            (context.resolve(names));

        /*
         * Get the CORBA OTS Current interface for controlling
         * transactions.  If your ORB does not support
         * CosTransactions, comment out the following line:
         */
        Current currentTX = CurrentHelper.narrow
            (orb.resolve_initial_references("TransactionCurrent"));

        /*
         * Begin the transaction.
         * If your ORB does not support CosTransactions, comment
         * out the following line:
         */
        currentTX.begin();

        /*
         * Use the home object to create an EJB object
         */
        Hello hello = helloHome.create();

        /*
         * Call a business method. Note trailing '_' in the method name,
         * which was introduced by the Java-to-IDL mapping rules:
         */
        System.out.println(hello.hello_()); 

        /*
         * Remove the EJB object
         */
        hello.remove();

        /*
         * Commit the transaction
         * If your ORB does not support CosTransactions, comment
         * out the following line:
         */
        currentTX.commit(true);
    }
}

